/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.selenium;

import com.thoughtworks.selenium.Wait;
import org.jboss.seam.example.common.test.selenium.SeamSeleniumTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class SeleniumBookingTest
extends SeamSeleniumTest {
    private final String DEFAULT_USERNAME = "demo";
    private final String DEFAULT_PASSWORD = "demo";

    @BeforeMethod
    public void setUp() {
        super.setUp();
        AssertJUnit.assertTrue((String)"Login failed.", (boolean)this.login());
    }

    @AfterMethod
    public void tearDown() {
        this.logout();
        super.tearDown();
    }

    public boolean login() {
        return this.login("demo", "demo");
    }

    public boolean login(String username, String password) {
        if (this.isLoggedIn()) {
            AssertJUnit.fail((String)"User already logged in.");
        }
        browser.open(this.CONTEXT_PATH + this.getProperty("HOME_PAGE"));
        browser.waitForPageToLoad(TIMEOUT);
        if (!browser.getTitle().equals(this.getProperty("PAGE_TITLE"))) {
            return false;
        }
        browser.type(this.getProperty("LOGIN_USERNAME_FIELD"), username);
        browser.type(this.getProperty("LOGIN_PASSWORD_FIELD"), password);
        browser.click(this.getProperty("LOGIN_SUBMIT"));
        browser.waitForPageToLoad(TIMEOUT);
        return this.isLoggedIn();
    }

    public void logout() {
        if (this.isLoggedIn()) {
            browser.click(this.getProperty("LOGOUT"));
            browser.waitForPageToLoad(TIMEOUT);
        }
    }

    public boolean isLoggedIn() {
        return browser.isElementPresent(this.getProperty("LOGOUT"));
    }

    public void enterSearchQuery(String query) {
        if (this.getProperty("USE_AJAX_SEARCH").equalsIgnoreCase("FALSE")) {
            this.enterSearchQueryWithoutAJAX(query);
        } else if (this.getProperty("USE_SEARCH_BUTTON").equalsIgnoreCase("TRUE")) {
            this.enterSearchQueryUsingAJAX(query, true);
        } else {
            this.enterSearchQueryUsingAJAX(query, false);
        }
    }

    public void enterSearchQueryUsingAJAX(String query, boolean click) {
        browser.type(this.getProperty("SEARCH_STRING_FIELD"), "");
        browser.type(this.getProperty("SEARCH_STRING_FIELD"), query.substring(0, query.length() - 1));
        browser.typeKeys(this.getProperty("SEARCH_STRING_FIELD"), query.substring(query.length() - 1));
        if (click) {
            browser.click(this.getProperty("SEARCH_SUBMIT"));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        new Wait(){

            public boolean until() {
                return !SeamSeleniumTest.browser.isVisible(SeleniumBookingTest.this.getProperty("SPINNER"));
            }
        }.wait("Spinner hasn't come out.");
        new Wait(){

            public boolean until() {
                return SeamSeleniumTest.browser.isElementPresent(SeleniumBookingTest.this.getProperty("SEARCH_RESULT_TABLE")) || SeamSeleniumTest.browser.isElementPresent(SeleniumBookingTest.this.getProperty("NO_HOTELS_FOUND"));
            }
        }.wait("Search results not found.");
    }

    public void enterSearchQueryWithoutAJAX(String query) {
        browser.type(this.getProperty("SEARCH_STRING_FIELD"), "");
        browser.type(this.getProperty("SEARCH_STRING_FIELD"), query);
        browser.click(this.getProperty("SEARCH_SUBMIT"));
        browser.waitForPageToLoad(TIMEOUT);
    }

    public void waitForForm() {
        if (this.getProperty("USE_ICEFACES_FORMS").equalsIgnoreCase("TRUE")) {
            new Wait(){

                public boolean until() {
                    return !SeamSeleniumTest.browser.isElementPresent("xpath=//*[@style='cursor: wait;']") && SeamSeleniumTest.browser.isElementPresent(SeleniumBookingTest.this.getProperty("FOOTER"));
                }
            }.wait("Page was not refreshed.");
        } else {
            browser.waitForPageToLoad(TIMEOUT);
        }
    }
}

