/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.seampay.selenium;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.jboss.seam.example.common.test.selenium.SeamSeleniumTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PaymentTest
extends SeamSeleniumTest {
    protected NumberFormat nf = NumberFormat.getNumberInstance();

    @BeforeMethod
    public void setUp() {
        super.setUp();
        browser.open(this.CONTEXT_PATH + this.getProperty("MAIN_PAGE"));
        browser.waitForPageToLoad(TIMEOUT);
    }

    @Test
    public void payOnceTest() throws ParseException {
        int account = 0;
        BigDecimal amount = new BigDecimal(10);
        String to = "foo";
        String accountLinkLocator = MessageFormat.format(this.getProperty("ACCOUNT_TABLE_LINK"), account);
        String accountBalanceLocator = MessageFormat.format(this.getProperty("ACCOUNT_TABLE_BALANCE"), account);
        browser.click(accountLinkLocator);
        browser.waitForPageToLoad(TIMEOUT);
        BigDecimal expectedBalance = BigDecimal.valueOf(this.parseBalance(browser.getText(accountBalanceLocator)));
        this.submitPayment(to, amount.toString(), this.getProperty("PAYMENT_ONLY_ONCE_RADIO"));
        AssertJUnit.assertTrue((String)"Scheduled payment not confirmed.", (boolean)browser.isTextPresent(MessageFormat.format(this.getProperty("PAYMENT_CONFIRMATION_MESSAGE"), to)));
        AssertJUnit.assertEquals((String)"Invalid count of payments.", (Object)1, (Object)browser.getXpathCount(this.getProperty("PAYMENTS_COUNT")));
        browser.click(accountLinkLocator);
        browser.waitForPageToLoad(TIMEOUT);
        AssertJUnit.assertEquals((String)"No money were subtracted from account", (Object)expectedBalance.subtract(amount), (Object)BigDecimal.valueOf(this.parseBalance(browser.getText(accountBalanceLocator))));
    }

    @Test
    public void payEveryMinuteTest() throws ParseException, InterruptedException {
        int account = 1;
        BigDecimal amount = new BigDecimal(10);
        String to = "foo";
        String accountLinkLocator = MessageFormat.format(this.getProperty("ACCOUNT_TABLE_LINK"), account);
        String accountBalanceLocator = MessageFormat.format(this.getProperty("ACCOUNT_TABLE_BALANCE"), account);
        browser.click(accountLinkLocator);
        browser.waitForPageToLoad(TIMEOUT);
        this.submitPayment(to, amount.toString(), this.getProperty("PAYMENT_EVERY_MINUTE_RADIO"));
        AssertJUnit.assertTrue((String)"Scheduled payment not confirmed.", (boolean)browser.isTextPresent(MessageFormat.format(this.getProperty("PAYMENT_CONFIRMATION_MESSAGE"), to)));
        AssertJUnit.assertEquals((String)"Invalid count of payments.", (Object)1, (Object)browser.getXpathCount(this.getProperty("PAYMENTS_COUNT")));
        Thread.sleep(5000L);
        browser.click(accountLinkLocator);
        browser.waitForPageToLoad(TIMEOUT);
        BigDecimal firstBalance = BigDecimal.valueOf(this.parseBalance(browser.getText(accountBalanceLocator)));
        Thread.sleep(60000L);
        browser.click(accountLinkLocator);
        browser.waitForPageToLoad(TIMEOUT);
        BigDecimal secondBalance = BigDecimal.valueOf(this.parseBalance(browser.getText(accountBalanceLocator)));
        BigDecimal expectedSecondBalance = firstBalance.subtract(amount);
        AssertJUnit.assertEquals((String)"No money were subtracted from account after a minute", (Object)expectedSecondBalance, (Object)secondBalance);
    }

    protected void submitPayment(String to, String amount, String radio) {
        browser.type(this.getProperty("PAYMENT_TO_FIELD"), to);
        browser.type(this.getProperty("PAYMENT_AMOUNT_FIELD"), amount.toString());
        browser.check(radio);
        browser.click(this.getProperty("PAYMENT_SUBMIT"));
        browser.waitForPageToLoad(TIMEOUT);
    }

    protected Double parseBalance(String text) throws ParseException {
        String number = text.replaceAll("\\$", new String()).replaceAll(" ", new String()).trim();
        return this.nf.parse(number).doubleValue();
    }
}

