/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.selenium;

import java.io.IOException;
import java.util.Properties;
import org.jboss.seam.example.common.test.selenium.SeamSelenium;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public abstract class SeamSeleniumTest {
    protected static String HOST;
    protected static int PORT;
    protected static String BROWSER;
    protected static String BROWSER_URL;
    protected static String SPEED;
    public static String TIMEOUT;
    private static String PROPERTY_FILE;
    protected String CONTEXT_PATH = "";
    private static Properties properties;
    private static boolean propertiesLoaded;
    protected static String APP_NAME;
    protected static String OUTPUT_DIR;
    protected static String JBOSS_HOME;
    protected static String CONTAINER;
    public static SeamSelenium browser;

    @BeforeClass
    @Parameters(value={"selenium.host", "selenium.server.port", "selenium.browser", "selenium.browser.url", "selenium.speed", "selenium.timeout", "PROPERTY_FILE", "example.context.path", "selenium.output.dir", "jboss.home", "container"})
    public void setParameters(String host, String port, String browser, String browserUrl, String speed, String timeout, String propertyFile, @Optional(value="") String contextPath, String outputDir, String jbossHome, String container) {
        HOST = host;
        PORT = Integer.parseInt(port);
        BROWSER = browser;
        BROWSER_URL = browserUrl;
        SPEED = speed;
        TIMEOUT = timeout;
        PROPERTY_FILE = propertyFile;
        this.CONTEXT_PATH = APP_NAME = contextPath;
        OUTPUT_DIR = outputDir;
        JBOSS_HOME = jbossHome;
        CONTAINER = container;
    }

    @BeforeMethod
    public void setUp() {
        browser = this.startBrowser();
    }

    @AfterMethod
    public void tearDown() {
    }

    public SeamSelenium startBrowser() {
        SeamSelenium newBrowser = new SeamSelenium(HOST, PORT, BROWSER, BROWSER_URL);
        newBrowser.start();
        newBrowser.allowNativeXpath("false");
        newBrowser.setSpeed(SPEED);
        newBrowser.setTimeout(TIMEOUT);
        return newBrowser;
    }

    public void stopBrowser() {
        if (browser != null) {
            browser.stop();
        }
    }

    public String getProperty(String key) {
        if (!propertiesLoaded) {
            try {
                properties.load(SeamSeleniumTest.class.getResourceAsStream(PROPERTY_FILE));
                propertiesLoaded = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                AssertJUnit.fail((String)"Property file not found.");
            }
        }
        return properties.getProperty(key, "Property not found: " + key);
    }

    public static String getBrowser() {
        return BROWSER;
    }

    public static void setBrowser(String browser) {
        BROWSER = browser;
    }

    static {
        properties = new Properties();
        propertiesLoaded = false;
    }
}

