/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.webdriver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.seam.example.common.test.webdriver.AjaxWebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedWebElement
implements AjaxWebElement {
    private int waitTime;
    private WebElement element;

    public DelegatedWebElement(WebElement element) {
        this(element, 3000);
    }

    public DelegatedWebElement(WebElement element, int waitTime) {
        this.element = element;
        this.waitTime = waitTime;
    }

    public void clear() {
        this.element.clear();
    }

    @Override
    public void clearAndSendKeys(CharSequence ... keysToSend) {
        this.element.clear();
        this.element.sendKeys(keysToSend);
    }

    public void click() {
        this.element.click();
    }

    @Override
    public void clickAndWait() {
        this.element.click();
        try {
            Thread.sleep(this.waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void clickAndWait(int millis) {
        this.element.click();
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public AjaxWebElement findElement(By by) {
        return new DelegatedWebElement(this.element.findElement(by));
    }

    public List<WebElement> findElements(By by) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        List original = this.element.findElements(by);
        if (original == null || original.size() == 0) {
            return Collections.emptyList();
        }
        for (WebElement e : original) {
            elements.add(new DelegatedWebElement(e));
        }
        return elements;
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public String getElementName() {
        return this.element.getElementName();
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public String getText() {
        return this.element.getText();
    }

    public String getValue() {
        return this.element.getValue();
    }

    public boolean isEnabled() {
        return this.element.isEnabled();
    }

    public boolean isSelected() {
        return this.element.isSelected();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.element.sendKeys(keysToSend);
    }

    public void setSelected() {
        this.element.setSelected();
    }

    @Override
    public void setWaitTime(int millis) {
        this.waitTime = millis;
    }

    public void submit() {
        this.element.submit();
    }

    public boolean toggle() {
        return this.element.toggle();
    }
}

