/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.webdriver;

import com.thoughtworks.selenium.Wait;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.jboss.seam.example.common.test.webdriver.AjaxWebDriver;
import org.jboss.seam.example.common.test.webdriver.AjaxWebDriverTest;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConversationTest
extends AjaxWebDriverTest {
    public int timeout = 5000;
    private final String DEFAULT_USERNAME = "demo";
    private final String DEFAULT_PASSWORD = "demo";
    private final int W1 = 0;
    private final int W2 = 1;
    public final String MAIN_PAGE = "/main.seam";
    public final String HOME_PAGE = "/home.seam";
    public final String HOTEL1 = "Hotel Rouge";
    public final String HOTEL2 = "Doubletree";
    public final String PAGE_TITLE = "JBoss Suites: Seam Framework";
    public final String WORKSPACE_BOOKING_TEXT_HOTEL1 = "Book hotel: Hotel Rouge";
    public final String WORKSPACE_VIEW_TEXT_HOTEL2 = "View hotel: Doubletree";
    public final By LOGIN_USERNAME_FIELD = By.id((String)"login:username");
    public final By LOGIN_PASSWORD_FIELD = By.id((String)"login:password");
    public final By LOGIN_SUBMIT = By.id((String)"login:login");
    public final By SEARCH_STRING_FIELD = By.id((String)"searchCriteria:searchString");
    public final By SPINNER = By.id((String)"searchCriteria:Spinner:connection-working");
    public final By SEARCH_RESULT_TABLE = By.xpath((String)"//table[@id = 'searchResults:hotels']/tbody");
    public final By NO_HOTELS_FOUND = By.id((String)"searchResults:NoHotelsFoundMessage");
    public final By WORKSPACE_LINK_0 = By.id((String)"ConversationListForm:ConversationListDataTable:0:EntryDescriptionLink");
    public final By WORKSPACE_LINK_1 = By.id((String)"ConversationListForm:ConversationListDataTable:1:EntryDescriptionLink");
    public final By SEARCH_RESULT_TABLE_FIRST_ROW_LINK = By.id((String)"searchResults:hotels:0:viewHotel");
    public final By BOOKING_BOOK = By.id((String)"hotel:bookHotel");
    public final By BOOKING_CANCEL = By.id((String)"hotel:cancel");
    public final By LOGOUT = By.id((String)"logout");
    public final By WORKSPACE_TABLE_ROW_COUNT = By.xpath((String)"//table[@id='ConversationListForm:ConversationListDataTable']/tbody/tr");
    public List<String> windows = new ArrayList<String>();

    @BeforeMethod
    public void setUp() {
        this.driver.get(String.valueOf(this.serverURL) + this.contextPath + "/main.seam");
        this.openWindow(this.driver, String.valueOf(this.serverURL) + this.contextPath + "/main.seam", "window2");
        for (String h : this.driver.getWindowHandles()) {
            this.windows.add(h);
        }
    }

    @AfterMethod
    public void tearDown() {
        this.closeWindows();
    }

    @Test
    public void testConversations() {
        this.driver.switchTo().window(this.windows.get(0));
        if (!this.isLoggedIn(this.driver)) {
            this.login(this.driver);
        }
        this.enterSearchQueryUsingAJAX(this.driver, "Hotel Rouge");
        this.pause(this.timeout);
        this.driver.findElement(this.SEARCH_RESULT_TABLE_FIRST_ROW_LINK).clickAndWait();
        this.driver.findElement(this.BOOKING_BOOK).click();
        this.driver.switchTo().window(this.windows.get(1));
        this.driver.navigate().refresh();
        this.pause(this.timeout);
        if (!this.isLoggedIn(this.driver)) {
            this.login(this.driver);
        }
        this.pause(this.timeout);
        this.enterSearchQueryUsingAJAX(this.driver, "Doubletree");
        this.driver.findElement(this.SEARCH_RESULT_TABLE_FIRST_ROW_LINK).clickAndWait();
        this.driver.switchTo().window(this.windows.get(0));
        this.driver.navigate().refresh();
        this.pause(this.timeout);
        Assert.assertEquals((String)"#1 workspace not present in workspace table", (String)"Book hotel: Hotel Rouge", (String)this.driver.findElement(this.WORKSPACE_LINK_0).getText());
        Assert.assertEquals((String)"#2 workspace not present in workspace table", (String)"View hotel: Doubletree", (String)this.driver.findElement(this.WORKSPACE_LINK_1).getText());
        this.driver.findElement(this.WORKSPACE_LINK_1).clickAndWait();
        this.driver.findElement(this.WORKSPACE_LINK_1).clickAndWait();
        this.driver.switchTo().window(this.windows.get(1));
        this.driver.findElement(this.BOOKING_CANCEL).clickAndWait();
        Assert.assertTrue((String)"Workspace failure.", (this.driver.findElements(this.WORKSPACE_TABLE_ROW_COUNT).size() == 1 ? 1 : 0) != 0);
    }

    public void enterSearchQueryUsingAJAX(final AjaxWebDriver driver, String query) {
        driver.findElement(this.SEARCH_STRING_FIELD).clearAndSendKeys(query.substring(0, query.length() - 1));
        driver.findElement(this.SEARCH_STRING_FIELD).sendKeys(new CharSequence[]{query.substring(query.length() - 1)});
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        new Wait(){

            public boolean until() {
                return driver.isElementPresent(ConversationTest.this.SEARCH_RESULT_TABLE) || driver.isElementPresent(ConversationTest.this.NO_HOTELS_FOUND);
            }
        }.wait("Search results not found.");
    }

    public boolean login(AjaxWebDriver driver) {
        return this.login(driver, "demo", "demo");
    }

    public boolean login(AjaxWebDriver driver, String username, String password) {
        driver.get(String.valueOf(this.serverURL) + this.contextPath + "/home.seam");
        this.pause(this.timeout);
        if (!driver.getTitle().equals("JBoss Suites: Seam Framework")) {
            return false;
        }
        driver.findElement(this.LOGIN_USERNAME_FIELD).sendKeys(new CharSequence[]{username});
        driver.findElement(this.LOGIN_PASSWORD_FIELD).sendKeys(new CharSequence[]{password});
        driver.findElement(this.LOGIN_SUBMIT).clickAndWait();
        this.pause(this.timeout);
        return this.isLoggedIn(driver);
    }

    public boolean isLoggedIn(AjaxWebDriver driver) {
        return driver.isElementPresent(this.LOGOUT);
    }

    public void openWindow(AjaxWebDriver driver, String url, String windowName) {
        ((JavascriptExecutor)driver).executeScript("window.open('" + url + "','" + windowName + "')", new Object[0]);
    }

    public void closeWindows() {
        for (String h : this.windows) {
            this.driver.switchTo().window(h);
            this.driver.close();
        }
    }

    private void pause(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

