/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.Wait;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;

public class SeamSelenium
extends DefaultSelenium {
    private String timeout = "30000";
    private boolean icefacesDetection = false;
    private long icefacesWaitTime = 1000L;
    private long windowMaximizeWaitTime = 5000L;
    private final String ICEFACES_CONNECTION_STATUS = "xpath=//div[@class='iceOutConStat connectionStatus']";
    private final String ICEFACES_IDLE_VISIBLE = "xpath=//div[@class='iceOutConStatInactv connectionStatusInactv'][@style='visibility: visible;']";

    public SeamSelenium(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        super(serverHost, serverPort, browserStartCommand, browserURL);
    }

    public void clickAndWait(String locator) {
        this.click(locator);
        this.waitForPageToLoad();
    }

    public void goBackAndWait() {
        super.goBack();
        super.waitForPageToLoad(this.timeout);
    }

    public void refreshAndWait() {
        super.refresh();
        super.waitForPageToLoad(this.timeout);
    }

    public void setTimeout(String timeout) {
        super.setTimeout(timeout);
        this.timeout = timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(this.timeout);
    }

    public void waitForPageToLoad(String timeout) {
        if (this.icefacesDetection && this.isElementPresent("xpath=//div[@class='iceOutConStat connectionStatus']")) {
            this.waitForIcefaces(this.icefacesWaitTime, Long.valueOf(timeout));
        } else {
            super.waitForPageToLoad(timeout);
        }
    }

    public void waitForAJAXUpdate() {
        this.waitForAJAXUpdate(this.timeout);
    }

    public void waitForAJAXUpdate(String timeout) {
        if (this.icefacesDetection) {
            this.waitForCondition("selenium.browserbot.getCurrentWindow().Ajax.activeRequestCount===0", timeout);
        } else {
            this.waitForCondition("selenium.browserbot.getCurrentWindow().jQuery.active===0", timeout);
        }
    }

    public void waitForElement(String locator) {
        this.waitForElement(locator, Long.valueOf(this.timeout));
    }

    public void waitForElement(final String locator, long timeout) {
        new Wait(){

            public boolean until() {
                return SeamSelenium.this.isElementPresent(locator);
            }
        }.wait("Timeout while waiting for asynchronous update of " + locator, timeout);
    }

    public void waitForElementNotPresent(final String locator, long timeout) {
        new Wait(){

            public boolean until() {
                return !SeamSelenium.this.isElementPresent(locator);
            }
        }.wait("Timeout while waiting for asynchronous update of " + locator, timeout);
    }

    public void selectWindow(String windowID) {
        super.selectWindow(windowID);
        this.refresh();
        this.waitForPageToLoad();
    }

    public boolean isIcefacesDetection() {
        return this.icefacesDetection;
    }

    public void setIcefacesDetection(boolean icefacesDetection) {
        this.icefacesDetection = icefacesDetection;
    }

    public long getIcefacesWaitTime() {
        return this.icefacesWaitTime;
    }

    public void setIcefacesWaitTime(long icefacesWaitTime) {
        this.icefacesWaitTime = icefacesWaitTime;
    }

    public void captureScreenshot(String path) {
        this.windowMaximize();
        try {
            Thread.sleep(this.windowMaximizeWaitTime);
        }
        catch (InterruptedException interruptedException) {}
        super.captureScreenshot(path);
    }

    public void logHTMLContext(String path) {
        String source = this.getHtmlSource();
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
                writer.write(source);
                writer.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to save HTML body", e);
            }
        }
        catch (Throwable throwable) {
            try {
                writer.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            writer.close();
        }
        catch (Exception exception) {}
    }

    private void waitForIcefaces(Long waitTime, Long timeout) {
        new Wait(){

            public boolean until() {
                return SeamSelenium.this.isElementPresent("xpath=//div[@class='iceOutConStatInactv connectionStatusInactv'][@style='visibility: visible;']");
            }
        }.wait("Timeout while waiting for icefaces idle state.", timeout.longValue());
        try {
            Thread.sleep(this.icefacesWaitTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new Wait(){

            public boolean until() {
                return SeamSelenium.this.isElementPresent("xpath=//body");
            }
        }.wait("Timeout while waiting for document body after icefaces click.", timeout.longValue());
    }

    public void open(String url) {
        try {
            super.open(url);
        }
        catch (SeleniumException seleniumException) {}
    }
}

