/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.seam.example.common.test.xml.NodeCondition;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeamXMLTest {
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static XPathFactory xpf = XPathFactory.newInstance();
    protected String BROWSER_URL;
    protected String CONTEXT_PATH;
    protected boolean NAMESPACE_AWARE;
    protected DocumentBuilder db;
    protected XPath xp;

    @BeforeClass
    @Parameters(value={"selenium.browser.url", "example.context.path", "xml.namespace.aware"})
    public void setParameters(String browserURL, @Optional(value="") String contextPath, @Optional(value="true") String namespaceAware) {
        this.BROWSER_URL = browserURL;
        this.CONTEXT_PATH = contextPath;
        this.NAMESPACE_AWARE = Boolean.parseBoolean(namespaceAware);
    }

    @BeforeClass
    @Parameters(value={"xml.namespace.aware"})
    public void initializeBuilders() throws ParserConfigurationException {
        dbf.setNamespaceAware(this.NAMESPACE_AWARE);
        this.db = dbf.newDocumentBuilder();
        this.xp = xpf.newXPath();
    }

    protected List<Node> evaluateXPath(Node root, String xpath) throws XPathExpressionException {
        NodeList nl = (NodeList)this.xp.compile(xpath).evaluate(root, XPathConstants.NODESET);
        ArrayList<Node> list = new ArrayList<Node>(nl.getLength());
        int i = 0;
        int max = nl.getLength();
        while (i < max) {
            list.add(nl.item(i));
            ++i;
        }
        return list;
    }

    protected boolean evaluateXPathCondition(Node root, String xpath, NodeCondition ... conditions) throws XPathExpressionException {
        return this.evaluateCondition(this.evaluateXPath(root, xpath), conditions);
    }

    protected boolean evaluateCondition(List<Node> list, NodeCondition ... conditions) {
        for (Node node : list) {
            NodeCondition[] nodeConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                NodeCondition condition = nodeConditionArray[n2];
                if (!condition.match(node)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

