/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.selenium;

import java.text.MessageFormat;
import java.util.Date;
import org.jboss.seam.example.common.test.booking.selenium.SeleniumBookingTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RegistrationTest
extends SeleniumBookingTest {
    private final String LONG_TEXT = "testertestertest";
    private final String SHORT_TEXT = "tes";
    private String suffix;

    public RegistrationTest() {
        Date date = new Date();
        this.suffix = Long.toString(date.getTime() % 10000000L);
    }

    @Override
    @BeforeMethod
    public void setUp() {
        browser = this.startBrowser();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.stopBrowser();
    }

    @Test
    public void testVerify() {
        this.register("tester", "tester", "password", "password1");
        AssertJUnit.assertTrue((String)"Password verification failed.", (boolean)browser.isTextPresent(this.getProperty("REGISTRATION_REENTER_MESSAGE")));
    }

    @Test
    public void testLongText() {
        this.register("testertestertest", "tester", "password", "password");
        AssertJUnit.assertTrue((String)"Username validation failed.", (boolean)browser.isTextPresent(this.getProperty("REGISTRATION_LENGTH_MESSAGE")));
    }

    @Test
    public void testShortText() {
        this.register("tes", "tester", "password", "password");
        AssertJUnit.assertTrue((String)"Username validation failed.", (boolean)browser.isTextPresent(this.getProperty("REGISTRATION_LENGTH_MESSAGE")));
    }

    @Test
    public void testDuplicateUser() {
        String username = "tester" + this.suffix;
        this.register(username, "tester", "password", "password");
        AssertJUnit.assertTrue((String)"Navigation after succesful registration failed.", (boolean)browser.getLocation().contains(this.getProperty("HOME_PAGE")));
        this.register(username, "tester", "password", "password");
        AssertJUnit.assertTrue((String)"Registered 2 users with the same username.", (boolean)browser.isTextPresent(MessageFormat.format(this.getProperty("REGISTRATION_USER_EXISTS_MESSAGE"), username)));
    }

    @Test
    public void standardRegistrationTest() {
        String username = "john" + this.suffix;
        String name = "John Doe";
        String password = "password";
        this.register(username, name, password, password);
        AssertJUnit.assertTrue((String)"Navigation after succesful registration failed.", (boolean)browser.getLocation().contains(this.getProperty("HOME_PAGE")));
        AssertJUnit.assertTrue((String)"Login failed.", (boolean)this.login(username, password));
        this.logout();
    }

    private void register(String username, String name, String password, String verify) {
        browser.open(this.CONTEXT_PATH + this.getProperty("HOME_PAGE"));
        browser.waitForPageToLoad(TIMEOUT);
        AssertJUnit.assertEquals((String)"Unable to load home page.", (String)this.getProperty("PAGE_TITLE"), (String)browser.getTitle());
        browser.click(this.getProperty("REGISTRATION"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.type(this.getProperty("REGISTRATION_USERNAME"), username);
        browser.type(this.getProperty("REGISTRATION_NAME"), name);
        browser.type(this.getProperty("REGISTRATION_PASSWORD"), password);
        browser.type(this.getProperty("REGISTRATION_VERIFY"), verify);
        browser.click(this.getProperty("REGISTRATION_SUBMIT"));
        this.waitForForm();
    }
}

