/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.numberguess.selenium;

import org.jboss.seam.example.common.test.selenium.SeamSeleniumTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CommonNumberGuessTest
extends SeamSeleniumTest {
    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        browser.open(this.CONTEXT_PATH + this.getProperty("MAIN_PAGE"));
        browser.waitForPageToLoad(TIMEOUT);
    }

    @Test
    public void smartTest() {
        int i = 0;
        while (browser.getLocation().contains(this.getProperty("GUESS_LOCATION"))) {
            if (i > 9) {
                AssertJUnit.fail((String)"Game should not be longer than 10 guesses");
            }
            int min = Integer.parseInt(browser.getText(this.getProperty("GUESS_MIN_VALUE")));
            int max = Integer.parseInt(browser.getText(this.getProperty("GUESS_MAX_VALUE")));
            int guess = min + (max - min) / 2;
            this.enterGuess(guess);
            ++i;
        }
        AssertJUnit.assertTrue((String)"Win page expected after playing smart.", (boolean)this.isOnWinPage());
    }

    @Test
    public void linearTest() {
        int guess = 0;
        while (browser.getLocation().contains(this.getProperty("GUESS_LOCATION"))) {
            this.enterGuess(++guess);
            AssertJUnit.assertTrue((String)"Guess count exceeded.", (guess <= 10 ? 1 : 0) != 0);
        }
        if (guess < 10) {
            AssertJUnit.assertTrue((String)"Player should not lose before 10th guess.", (boolean)this.isOnWinPage());
        } else {
            AssertJUnit.assertTrue((String)"After 10th guess player should lose or win.", (this.isOnLosePage() || this.isOnWinPage() ? 1 : 0) != 0);
        }
    }

    protected void enterGuess(int guess) {
        browser.type(this.getProperty("GUESS_FIELD"), String.valueOf(guess));
        browser.click(this.getProperty("GUESS_SUBMIT"));
        browser.waitForPageToLoad(TIMEOUT);
    }

    protected boolean isOnWinPage() {
        return browser.getLocation().contains(this.getProperty("WIN_LOCATION"));
    }

    protected boolean isOnLosePage() {
        return browser.getLocation().contains(this.getProperty("LOSE_LOCATION"));
    }
}

