/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.selenium;

import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jboss.seam.example.common.test.selenium.SeamSelenium;

public enum SeleniumDateSelector {
    RICHFACES{

        @Override
        public void setDay(SeamSelenium browser, int day) {
            String locator = "xpath=//td[contains(@class, 'rich-calendar-cell') and not(contains(@class,'rich-calendar-boundary-dates')) and text() ='" + Integer.toString(day) + "']";
            browser.waitForElement(locator);
            browser.click(locator);
        }

        @Override
        public void setMonth(SeamSelenium browser, int month) {
            String monthLocator = "xpath=//div[@class='rich-calendar-tool-btn' and contains(.,',')]";
            StringTokenizer stk = new StringTokenizer(browser.getText(monthLocator), ",");
            String calMonth = stk.nextToken().trim();
            int steps = this.monthStepsCount(calMonth, month);
            this.movement(browser, "xpath=//div[@class='rich-calendar-tool-btn' and normalize-space(text())='<']", "xpath=//div[@class='rich-calendar-tool-btn' and normalize-space(text())='>']", steps);
        }

        @Override
        public void setYear(SeamSelenium browser, int year) {
            String yearLocator = "xpath=//div[@class='rich-calendar-tool-btn' and contains(.,',')]";
            StringTokenizer stk = new StringTokenizer(browser.getText(yearLocator), ",");
            stk.nextToken();
            String calYear = stk.nextToken().trim();
            int steps = this.yearStepsCount(calYear, year);
            this.movement(browser, "xpath=//div[@class='rich-calendar-tool-btn' and normalize-space(text())='<<']", "xpath=//div[@class='rich-calendar-tool-btn' and normalize-space(text())='>>']", steps);
        }
    }
    ,
    ICEFACES{

        @Override
        public void setDay(SeamSelenium browser, int day) {
            String locator = "xpath=//td[normalize-space(@class)='iceSelInpDateDay']/a[./span/text()='" + Integer.toString(day) + "']";
            browser.waitForElement(locator);
            browser.click(locator);
        }

        @Override
        public void setMonth(SeamSelenium browser, int month) {
            String monthLocator = "xpath=//td[@class='iceSelInpDateMonthYear'][2]";
            String calMonth = browser.getText(monthLocator).trim();
            int steps = this.monthStepsCount(calMonth, month);
            this.movement(browser, "xpath=//td[@class='iceSelInpDateMonthYear'][1]/a", "xpath=//td[@class='iceSelInpDateMonthYear'][3]/a", steps);
        }

        @Override
        public void setYear(SeamSelenium browser, int year) {
            String yearLocator = "xpath=//td[@class='iceSelInpDateMonthYear'][6]";
            String calYear = browser.getText(yearLocator).trim();
            int steps = this.yearStepsCount(calYear, year);
            this.movement(browser, "xpath=//td[@class='iceSelInpDateMonthYear'][5]/a", "xpath=//td[@class='iceSelInpDateMonthYear'][7]/a", steps);
        }

        @Override
        protected void click(SeamSelenium browser, String locator) {
            browser.clickAndWait(locator);
        }
    };


    public void setDate(SeamSelenium browser, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.setYear(browser, cal.get(1));
        this.setMonth(browser, cal.get(2));
        this.setDay(browser, cal.get(5));
    }

    protected abstract void setDay(SeamSelenium var1, int var2);

    protected abstract void setMonth(SeamSelenium var1, int var2);

    protected abstract void setYear(SeamSelenium var1, int var2);

    protected int monthStepsCount(String calMonth, int month) {
        List<String> months = Arrays.asList(new DateFormatSymbols().getMonths());
        int mindex = months.indexOf(calMonth);
        if (mindex == -1) {
            throw new IllegalArgumentException("Unknown month: " + calMonth + " for locale: " + Locale.getDefault());
        }
        return month - (mindex + 1);
    }

    protected final int yearStepsCount(String calYear, int year) {
        int yindex;
        try {
            yindex = Integer.valueOf(calYear);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid year: " + calYear, nfe);
        }
        return year - yindex;
    }

    protected void movement(SeamSelenium browser, String backLocator, String forwardLocator, int steps) {
        if (steps < 0) {
            for (int i = 0; i > steps; --i) {
                this.click(browser, backLocator);
            }
        } else {
            for (int i = 0; i < steps; ++i) {
                this.click(browser, forwardLocator);
            }
        }
    }

    protected void click(SeamSelenium browser, String locator) {
        browser.click(locator);
    }
}

