/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.webdriver;

import org.jboss.seam.example.common.test.webdriver.AjaxWebDriver;
import org.jboss.seam.example.common.test.webdriver.FirefoxAjaxDriver;
import org.jboss.seam.example.common.test.webdriver.InternetExplorerAjaxDriver;

public class AjaxWebDriverFactory {
    public static final AjaxWebDriver getDriver(String browser) throws IllegalArgumentException, NullPointerException {
        if (browser.contains("firefox")) {
            return Browser.firefox.getDriver();
        }
        if (browser.contains("explore")) {
            return Browser.iexplorer.getDriver();
        }
        return Browser.valueOf(browser).getDriver();
    }

    public static final String availableBrowsers() {
        StringBuilder sb = new StringBuilder();
        for (Browser b : Browser.values()) {
            sb.append("'").append(b.toString()).append("' ");
        }
        return sb.toString();
    }

    public static enum Browser {
        firefox{

            @Override
            public AjaxWebDriver getDriver() {
                return new FirefoxAjaxDriver();
            }
        }
        ,
        iexplorer{

            @Override
            public AjaxWebDriver getDriver() {
                return new InternetExplorerAjaxDriver();
            }
        };


        public abstract AjaxWebDriver getDriver();
    }
}

