/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.selenium;

import org.jboss.seam.example.common.test.booking.selenium.SeleniumBookingTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class BackButtonTest
extends SeleniumBookingTest {
    String hotelName = "Mar";

    @Test
    public void backbuttoningAfterLogoutTest() {
        this.enterSearchQuery(this.hotelName);
        this.logout();
        browser.goBack();
        browser.waitForPageToLoad(TIMEOUT);
        if (this.isLoggedIn()) {
            browser.click(this.getProperty("SETTINGS"));
            browser.waitForPageToLoad(TIMEOUT);
            AssertJUnit.assertEquals((String)"Backbuttoning failed.", (String)this.getProperty("PAGE_TITLE"), (String)browser.getTitle());
            AssertJUnit.assertFalse((String)"Backbuttoning handled bad way.", (boolean)this.isLoggedIn());
        }
    }

    @Test
    public void backbuttoningAfterLogoutWithAjaxTest() {
        this.enterSearchQuery(this.hotelName);
        this.logout();
        browser.goBack();
        browser.waitForPageToLoad(TIMEOUT);
        if (this.isLoggedIn()) {
            browser.click(this.getProperty("SEARCH_SUBMIT"));
            browser.waitForPageToLoad(TIMEOUT);
            AssertJUnit.assertEquals((String)"Backbuttoning failed.", (String)this.getProperty("PAGE_TITLE"), (String)browser.getTitle());
            AssertJUnit.assertFalse((String)"User should not be logged in by now.", (boolean)this.isLoggedIn());
        }
    }

    @Test
    public void backbuttoningAfterConversationEndTest() {
        this.enterSearchQuery(this.hotelName);
        browser.click(this.getProperty("SEARCH_RESULT_TABLE_FIRST_ROW_LINK"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.click(this.getProperty("BOOKING_BOOK"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.click(this.getProperty("HOTEL_CANCEL"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.goBack();
        browser.waitForPageToLoad(TIMEOUT);
        browser.refresh();
        browser.waitForPageToLoad(TIMEOUT);
        AssertJUnit.assertTrue((String)"Conversation failure.", (boolean)browser.isTextPresent(this.getProperty("CONVERSATION_TIMEOUT_MESSAGE")));
    }
}

