/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.selenium;

import java.text.MessageFormat;
import org.jboss.seam.example.common.test.booking.selenium.SeleniumBookingTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SimpleBookingTest
extends SeleniumBookingTest {
    protected final String EXPECTED_NAME = "Demo User";
    protected final String CREDIT_CARD = "0123456789012345";
    protected final String CREDIT_CARD_NAME = "visa";

    @Test(enabled=true)
    public void invalidSearchStringTest() {
        this.enterSearchQuery("NonExistingHotel");
        AssertJUnit.assertTrue((String)"Search failed.", (boolean)browser.isElementPresent(this.getProperty("NO_HOTELS_FOUND")));
    }

    @Test(enabled=true)
    public void simpleBookingTest() {
        String hotelName = "W Hotel";
        int confirmationNumber = this.bookHotel(hotelName);
        AssertJUnit.assertTrue((String)("Booking with confirmation number " + confirmationNumber + " not found."), (boolean)browser.isElementPresent(MessageFormat.format(this.getProperty("BOOKING_TABLE_ITEM"), confirmationNumber, hotelName)));
    }

    @Test(enabled=true)
    public void invalidDatesTest() {
        String hotelName = "W Hotel";
        this.enterSearchQuery(hotelName);
        browser.click(this.getProperty("SEARCH_RESULT_TABLE_FIRST_ROW_LINK"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.click(this.getProperty("BOOKING_BOOK"));
        browser.waitForPageToLoad(TIMEOUT);
        String checkOut = browser.getValue(this.getProperty("HOTEL_CHECKOUT_DATE_FIELD"));
        this.populateBookingFields();
        browser.type(this.getProperty("HOTEL_CHECKIN_DATE_FIELD"), checkOut);
        browser.click(this.getProperty("HOTEL_PROCEED"));
        this.waitForForm();
        AssertJUnit.assertTrue((String)"Date verification #1 failed.", (boolean)browser.isTextPresent(this.getProperty("BOOKING_INVALID_DATE_MESSAGE1")));
        AssertJUnit.assertTrue((String)"Check-out date error message expected.", (boolean)browser.isElementPresent(this.getProperty("HOTEL_CHECKOUT_DATE_MESSAGE")));
        browser.type(this.getProperty("HOTEL_CHECKIN_DATE_FIELD"), "01/01/1970");
        browser.click(this.getProperty("HOTEL_PROCEED"));
        this.waitForForm();
        AssertJUnit.assertTrue((String)"Date verification #2 failed.", (boolean)browser.isTextPresent(this.getProperty("BOOKING_INVALID_DATE_MESSAGE2")));
        AssertJUnit.assertTrue((String)"Checkin-date error message expected.", (boolean)browser.isElementPresent(this.getProperty("HOTEL_CHECKIN_DATE_MESSAGE")));
    }

    @Test(enabled=true)
    public void testJBSEAM3288() {
        int i;
        String[] hotelNames = new String[]{"Doubletree", "Hotel Rouge", "Conrad Miami"};
        int[] confirmationNumbers = new int[3];
        for (i = 0; i < 3; ++i) {
            int confirmationNumber;
            confirmationNumbers[i] = confirmationNumber = this.bookHotel(hotelNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            AssertJUnit.assertTrue((String)("Expected booking #" + i + " not present"), (boolean)browser.isElementPresent(MessageFormat.format(this.getProperty("BOOKING_TABLE_ITEM"), confirmationNumbers[i], hotelNames[i])));
        }
        for (i = 2; i >= 0; --i) {
            browser.click(MessageFormat.format(this.getProperty("BOOKING_TABLE_ITEM_LINK"), confirmationNumbers[i], hotelNames[i]));
            browser.waitForPageToLoad(TIMEOUT);
            AssertJUnit.assertTrue((String)"Booking canceling failed", (boolean)browser.isTextPresent(MessageFormat.format(this.getProperty("BOOKING_CANCELLED_MESSAGE"), confirmationNumbers[i])));
        }
    }

    protected int bookHotel(String hotelName, int bed, int smoking, String creditCard, String creditCardName) {
        if (!this.isLoggedIn()) {
            AssertJUnit.fail();
        }
        if (!browser.isElementPresent(this.getProperty("SEARCH_SUBMIT"))) {
            browser.open(this.CONTEXT_PATH + this.getProperty("MAIN_PAGE"));
            browser.waitForPageToLoad(TIMEOUT);
        }
        this.enterSearchQuery(hotelName);
        browser.click(this.getProperty("SEARCH_RESULT_TABLE_FIRST_ROW_LINK"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.click(this.getProperty("BOOKING_BOOK"));
        browser.waitForPageToLoad(TIMEOUT);
        this.populateBookingFields(bed, smoking, creditCard, creditCardName);
        browser.click(this.getProperty("HOTEL_PROCEED"));
        browser.waitForPageToLoad(TIMEOUT);
        browser.click(this.getProperty("HOTEL_CONFIRM"));
        browser.waitForPageToLoad(TIMEOUT);
        String message = browser.getText(this.getProperty("HOTEL_MESSAGE"));
        AssertJUnit.assertTrue((String)"Booking failed. Confirmation message does not match.", (boolean)message.matches(MessageFormat.format(this.getProperty("BOOKING_CONFIRMATION_MESSAGE"), "Demo User", hotelName)));
        String[] messageParts = message.split(" ");
        int confirmationNumber = Integer.parseInt(messageParts[messageParts.length - 1]);
        return confirmationNumber;
    }

    protected int bookHotel(String hotelName) {
        return this.bookHotel(hotelName, 2, 0, "0123456789012345", "visa");
    }

    protected void populateBookingFields(int bed, int smoking, String creditCard, String creditCardName) {
        browser.select(this.getProperty("HOTEL_BED_FIELD"), this.getProperty("HOTEL_BED_FIELD_SELECT_CRITERIA") + bed);
        if (smoking == 1) {
            browser.check(this.getProperty("HOTEL_SMOKING_1"));
        } else {
            browser.check(this.getProperty("HOTEL_SMOKING_2"));
        }
        browser.type(this.getProperty("HOTEL_CREDIT_CARD"), creditCard);
        browser.type(this.getProperty("HOTEL_CREDIT_CARD_NAME"), creditCardName);
    }

    protected void populateBookingFields() {
        this.populateBookingFields(2, 0, "0123456789012345", "visa");
    }
}

