/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public abstract class SeamGrapheneTest {
    @Rule
    public MethodRule watchman = new TestWatchman(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable e, FrameworkMethod method) {
            FilterOutputStream bos = null;
            BufferedWriter bw = null;
            File testOutput = new File("target/test-output");
            if (!testOutput.exists()) {
                testOutput.mkdirs();
            }
            try {
                SeamGrapheneTest.this.browser.manage().window().maximize();
                byte[] screenshot = (byte[])((TakesScreenshot)SeamGrapheneTest.this.browser).getScreenshotAs(OutputType.BYTES);
                bos = new BufferedOutputStream(new FileOutputStream(testOutput.getAbsolutePath() + "/" + method.getName() + ".png"));
                bos.write(screenshot);
                bos.close();
                bw = new BufferedWriter(new FileWriter(testOutput.getAbsolutePath() + "/" + method.getName() + ".html"));
                bw.write(SeamGrapheneTest.this.browser.getPageSource());
                bw.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    bos.close();
                    bw.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    };
    private static String PROPERTY_FILE = "/ftest.properties";
    private static boolean propertiesLoaded = false;
    private static boolean propertiesExist = false;
    private static Properties properties = new Properties();
    @Drone
    public WebDriver browser;
    @ArquillianResource
    protected URL contextPath;

    @Before
    public void beforeTest() throws MalformedURLException {
        this.open(this.contextPath.toString());
    }

    public static String getProperty(String key, Object ... args) {
        String propValue;
        if (!propertiesLoaded) {
            try {
                InputStream is = SeamGrapheneTest.class.getResourceAsStream(PROPERTY_FILE);
                if (is == null) {
                    propertiesLoaded = true;
                    propertiesExist = false;
                } else {
                    properties.load(is);
                    propertiesLoaded = true;
                    propertiesExist = true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String string = propValue = propertiesExist ? properties.getProperty(key) : null;
        if (propValue != null && args.length != 0) {
            return MessageFormat.format(propValue, args);
        }
        return propValue;
    }

    public By getBy(String seleniumLocatorProperty, Object ... args) {
        String seleniumLocator = SeamGrapheneTest.getProperty(seleniumLocatorProperty, new Object[0]);
        if (seleniumLocator == null) {
            seleniumLocator = seleniumLocatorProperty;
        }
        String locator = seleniumLocator.substring(seleniumLocator.indexOf("=") + 1);
        if (args.length != 0) {
            locator = MessageFormat.format(locator, args);
        }
        if (seleniumLocator.startsWith("id")) {
            return By.id((String)locator);
        }
        if (seleniumLocator.startsWith("xpath")) {
            return By.xpath((String)locator);
        }
        if (seleniumLocator.startsWith("css")) {
            return By.cssSelector((String)locator);
        }
        if (seleniumLocator.startsWith("link")) {
            return By.linkText((String)locator);
        }
        if (seleniumLocator.startsWith("name")) {
            return By.name((String)locator);
        }
        return null;
    }

    public boolean isElementPresent(By by) {
        try {
            return this.browser.findElement(by).isDisplayed();
        }
        catch (NotFoundException nfe) {
            return false;
        }
    }

    public String getText(By by) {
        return this.browser.findElement(by).getText();
    }

    public void check(By by) {
        WebElement checkbox = this.browser.findElement(by);
        if (!checkbox.isSelected()) {
            checkbox.click();
        }
    }

    public void click(By by) {
        this.browser.findElement(by).click();
    }

    public void clickAndWaitHttp(By by) {
        ((WebElement)Graphene.guardHttp((Object)this.browser.findElement(by))).click();
    }

    public void clickAndWaitAjax(By by) {
        ((WebElement)Graphene.guardAjax((Object)this.browser.findElement(by))).click();
    }

    public void type(By by, CharSequence text, boolean clear) {
        WebElement elem = this.browser.findElement(by);
        if (clear) {
            elem.clear();
        }
        elem.sendKeys(new CharSequence[]{text});
    }

    public void type(By by, CharSequence text) {
        this.type(by, text, true);
    }

    public void setTextInputValue(By by, String value) {
        ((JavascriptExecutor)this.browser).executeScript("document.getElementById(arguments[0]).value = arguments[1]", new Object[]{this.browser.findElement(by).getAttribute("id"), value});
    }

    public boolean isTextInSource(String text) {
        return this.browser.getPageSource().contains(text);
    }

    public boolean isTextOnPage(String text) {
        return this.browser.findElement(By.tagName((String)"body")).getText().contains(text);
    }

    public void selectByValue(By by, Object value) {
        new Select(this.browser.findElement(by)).selectByValue(String.valueOf(value));
    }

    public void selectByText(By by, Object value) {
        new Select(this.browser.findElement(by)).selectByVisibleText(String.valueOf(value));
    }

    public void selectByIndex(By by, int index) {
        new Select(this.browser.findElement(by)).selectByIndex(index);
    }

    public void openWindow(String url, String name) {
        ((JavascriptExecutor)this.browser).executeScript(MessageFormat.format("window.open(\"{0}\", \"{1}\")", url, name), new Object[0]);
    }

    public void selectWindow(String windowNameOrHandle) {
        this.selectWindow(windowNameOrHandle, true);
    }

    public void selectWindow(String windowNameOrHandle, boolean refresh) {
        this.browser.switchTo().window(windowNameOrHandle);
        if (refresh) {
            this.browser.navigate().refresh();
        }
    }

    public void open(String url) {
        this.browser.navigate().to(url);
        this.sleep(1000);
    }

    public int getXpathCount(By by) {
        return this.browser.findElements(by).size();
    }

    public void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isRealBrowser() {
        String webDriverClass = this.browser.getClass().toString().toLowerCase();
        return !webDriverClass.contains("phantom") && !webDriverClass.contains("htmlunit");
    }
}

