/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.graphene;

import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.example.common.test.booking.graphene.BookingFunctionalTestBase;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunAsClient
@RunWith(value=Arquillian.class)
public class BackButtonTest
extends BookingFunctionalTestBase {
    String hotelName = "Mar";

    @Before
    public void assumeNotHTMLUnit() {
        Assume.assumeTrue((boolean)this.isRealBrowser());
    }

    @Test
    public void backbuttoningAfterLogoutTest() {
        this.logout();
        this.browser.navigate().back();
        this.clickAndWaitHttp(this.getBy("SETTINGS", new Object[0]));
        Assert.assertTrue((boolean)this.browser.getCurrentUrl().contains(BackButtonTest.getProperty("HOME_PAGE", new Object[0])));
        Assert.assertEquals((String)"Backbuttoning failed.", (Object)BackButtonTest.getProperty("PAGE_TITLE", new Object[0]), (Object)this.browser.getTitle());
        Assert.assertTrue((String)"Login message not present", (boolean)this.isTextOnPage(BackButtonTest.getProperty("NOT_LOGGED_IN_MESSAGE", new Object[0])));
        Assert.assertFalse((String)"User is logged in after logout and backbuttoning", (boolean)this.isLoggedIn());
    }

    @Test
    public void backbuttoningAfterLogoutWithAjaxTest() {
        this.logout();
        this.browser.navigate().back();
        this.click(this.getBy("SEARCH_SUBMIT", new Object[0]));
        this.sleep(5000);
        Assert.assertTrue((boolean)this.browser.getCurrentUrl().contains(BackButtonTest.getProperty("HOME_PAGE", new Object[0])));
        Assert.assertEquals((String)"Backbuttoning failed.", (Object)BackButtonTest.getProperty("PAGE_TITLE", new Object[0]), (Object)this.browser.getTitle());
        Assert.assertTrue((String)"Login message not present", (this.isTextOnPage(BackButtonTest.getProperty("NOT_LOGGED_IN_MESSAGE", new Object[0])) || this.isTextOnPage("Session expired, please log in again") ? 1 : 0) != 0);
        Assert.assertFalse((String)"User is logged in after logout and backbuttoning", (boolean)this.isLoggedIn());
    }

    @Test
    public void backbuttoningAfterConversationEndTest() {
        this.enterSearchQuery(this.hotelName);
        this.clickAndWaitHttp(this.getBy("SEARCH_RESULT_TABLE_FIRST_ROW_LINK", new Object[0]));
        this.clickAndWaitHttp(this.getBy("BOOKING_BOOK", new Object[0]));
        this.clickAndWaitHttp(this.getBy("HOTEL_CANCEL", new Object[0]));
        this.browser.navigate().back();
        if (!this.isTextInSource(BackButtonTest.getProperty("CONVERSATION_TIMEOUT_MESSAGE", new Object[0]))) {
            this.browser.navigate().refresh();
        }
        Assert.assertTrue((String)"Conversation failure.", (boolean)this.isTextInSource(BackButtonTest.getProperty("CONVERSATION_TIMEOUT_MESSAGE", new Object[0])));
    }
}

