/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.graphene;

import com.google.common.base.Predicate;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.seam.example.common.test.DeploymentResolver;
import org.jboss.seam.example.common.test.SeamGrapheneTest;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.openqa.selenium.WebDriver;

public class BookingFunctionalTestBase
extends SeamGrapheneTest {
    private final String DEFAULT_USERNAME = "demo";
    private final String DEFAULT_PASSWORD = "demo";

    @Deployment(testable=false)
    public static Archive<?> createDeployment() {
        return DeploymentResolver.createDeployment();
    }

    @Before
    public void setUp() {
        Assert.assertTrue((String)"Login failed.", (boolean)this.login());
    }

    @After
    public void tearDown() {
        this.logout();
    }

    public boolean login() {
        return this.login("demo", "demo");
    }

    public boolean login(String username, String password) {
        if (this.isLoggedIn()) {
            Assert.fail((String)"User already logged in.");
        }
        this.open(this.contextPath + BookingFunctionalTestBase.getProperty("HOME_PAGE", new Object[0]));
        if (!this.browser.getTitle().equals(BookingFunctionalTestBase.getProperty("PAGE_TITLE", new Object[0]))) {
            return false;
        }
        this.type(this.getBy("LOGIN_USERNAME_FIELD", new Object[0]), username);
        this.type(this.getBy("LOGIN_PASSWORD_FIELD", new Object[0]), password);
        if ("TRUE".equalsIgnoreCase(BookingFunctionalTestBase.getProperty("USE_AJAX_LOGIN", new Object[0]))) {
            this.clickAndWaitAjax(this.getBy("LOGIN_SUBMIT", new Object[0]));
        } else {
            this.clickAndWaitHttp(this.getBy("LOGIN_SUBMIT", new Object[0]));
        }
        return this.isLoggedIn();
    }

    public void logout() {
        if (this.isLoggedIn()) {
            this.clickAndWaitHttp(this.getBy("LOGOUT", new Object[0]));
        }
    }

    public boolean isLoggedIn() {
        return this.isElementPresent(this.getBy("LOGOUT", new Object[0]));
    }

    public void enterSearchQuery(String query) {
        if ("FALSE".equalsIgnoreCase(BookingFunctionalTestBase.getProperty("USE_AJAX_SEARCH", new Object[0]))) {
            this.enterSearchQueryWithoutAJAX(query);
        } else if ("TRUE".equalsIgnoreCase(BookingFunctionalTestBase.getProperty("USE_SEARCH_BUTTON", new Object[0]))) {
            this.enterSearchQueryUsingAJAX(query, true);
        } else {
            this.enterSearchQueryUsingAJAX(query, false);
        }
    }

    public void enterSearchQueryUsingAJAX(String query, boolean click) {
        this.setTextInputValue(this.getBy("SEARCH_STRING_FIELD", new Object[0]), query.substring(0, query.length() - 1));
        this.type(this.getBy("SEARCH_STRING_FIELD", new Object[0]), query.substring(query.length() - 1), false);
        if (click) {
            this.clickAndWaitAjax(this.getBy("SEARCH_SUBMIT", new Object[0]));
        }
        ((IsElementBuilder)Graphene.waitModel((WebDriver)this.browser).until().element(this.getBy("SPINNER", new Object[0])).is().not()).visible();
        Graphene.waitModel((WebDriver)this.browser).until(new Predicate(){

            public boolean apply(Object input) {
                return BookingFunctionalTestBase.this.isElementPresent(BookingFunctionalTestBase.this.getBy("SEARCH_RESULT_TABLE", new Object[0])) || BookingFunctionalTestBase.this.isElementPresent(BookingFunctionalTestBase.this.getBy("NO_HOTELS_FOUND", new Object[0]));
            }
        });
    }

    public void enterSearchQueryWithoutAJAX(String query) {
        this.type(this.getBy("SEARCH_STRING_FIELD", new Object[0]), query);
        this.clickAndWaitHttp(this.getBy("SEARCH_SUBMIT", new Object[0]));
    }
}

