/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.graphene;

import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.example.common.test.booking.graphene.BookingFunctionalTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunAsClient
@RunWith(value=Arquillian.class)
public class ChangePasswordTest
extends BookingFunctionalTestBase {
    protected static final String LONG_TEXT = "testertestertest";
    protected static final String SHORT_TEXT = "tt";
    protected final String USERNAME = "gavin";
    protected final String PASSWORD = "foobar";

    @Override
    @Before
    public void setUp() {
        Assert.assertTrue((String)"Login failed.", (boolean)this.login("gavin", "foobar"));
    }

    @Test
    public void changePasswordTest() {
        this.changePassword("password");
        Assert.assertTrue((String)"Password change failed.", (boolean)this.isTextInSource(ChangePasswordTest.getProperty("PASSWORD_UPDATED_MESSAGE", new Object[0])));
        this.logout();
        Assert.assertTrue((String)"Login failed.", (boolean)this.login("gavin", "password"));
        this.changePassword("foobar");
        Assert.assertTrue((String)"Password change failed.", (boolean)this.isTextInSource(ChangePasswordTest.getProperty("PASSWORD_UPDATED_MESSAGE", new Object[0])));
        this.logout();
        Assert.assertTrue((String)"Login failed.", (boolean)this.login("gavin", "foobar"));
    }

    @Test
    public void usingDifferentPasswordsTest() {
        this.changePassword("password", "password1");
        Assert.assertTrue((String)"Password verification failed", (boolean)this.isTextInSource(ChangePasswordTest.getProperty("PASSWORD_REENTER_MESSAGE", new Object[0])));
    }

    @Test
    public void usingEmptyPasswordsTest() {
        this.changePassword("", "");
        Assert.assertEquals((String)"Password validation failed", (long)2L, (long)this.getXpathCount(this.getBy("PASSWORD_VALUE_REQUIRED_MESSAGE", new Object[0])));
    }

    @Test
    public void usingLongPasswordTest() {
        this.changePassword(LONG_TEXT, LONG_TEXT);
        Assert.assertTrue((String)"Password validation failed", (boolean)this.isTextInSource(ChangePasswordTest.getProperty("PASSWORD_LENGTH_MESSAGE", new Object[0])));
    }

    @Test
    public void usingShortPasswordTest() {
        this.changePassword(SHORT_TEXT, SHORT_TEXT);
        Assert.assertTrue((String)"Password validation failed", (boolean)this.isTextInSource(ChangePasswordTest.getProperty("PASSWORD_LENGTH_MESSAGE", new Object[0])));
    }

    public void changePassword(String newPassword) {
        this.changePassword(newPassword, newPassword);
    }

    public void changePassword(String newPassword, String verify) {
        this.clickAndWaitHttp(this.getBy("SETTINGS", new Object[0]));
        this.type(this.getBy("PASSWORD_PASSWORD", new Object[0]), newPassword);
        this.type(this.getBy("PASSWORD_VERIFY", new Object[0]), verify);
        this.clickAndWaitHttp(this.getBy("PASSWORD_SUBMIT", new Object[0]));
    }
}

