/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.graphene;

import java.util.Date;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.example.common.test.booking.graphene.BookingFunctionalTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunAsClient
@RunWith(value=Arquillian.class)
public class RegistrationTest
extends BookingFunctionalTestBase {
    private final String LONG_TEXT = "testertestertest";
    private final String SHORT_TEXT = "tes";
    private String suffix;

    public RegistrationTest() {
        Date date = new Date();
        this.suffix = Long.toString(date.getTime() % 10000000L);
    }

    @Override
    @Before
    public void setUp() {
    }

    @Override
    @After
    public void tearDown() {
    }

    @Test
    public void testVerify() {
        this.register("tester", "tester", "password", "password1");
        Assert.assertTrue((String)"Password verification failed.", (boolean)this.isTextInSource(RegistrationTest.getProperty("REGISTRATION_REENTER_MESSAGE", new Object[0])));
    }

    @Test
    public void testLongText() {
        this.register("testertestertest", "tester", "password", "password");
        Assert.assertTrue((String)"Username validation failed.", (boolean)this.isTextInSource(RegistrationTest.getProperty("REGISTRATION_LENGTH_MESSAGE", new Object[0])));
    }

    @Test
    public void testShortText() {
        this.register("tes", "tester", "password", "password");
        Assert.assertTrue((String)"Username validation failed.", (boolean)this.isTextInSource(RegistrationTest.getProperty("REGISTRATION_LENGTH_MESSAGE", new Object[0])));
    }

    @Test
    public void testDuplicateUser() {
        String username = "tester" + this.suffix;
        this.register(username, "tester", "password", "password");
        Assert.assertTrue((String)"Navigation after succesful registration failed.", (boolean)this.browser.getCurrentUrl().contains(RegistrationTest.getProperty("HOME_PAGE", new Object[0])));
        this.register(username, "tester", "password", "password");
        Assert.assertTrue((String)"Registered 2 users with the same username.", (boolean)this.isTextInSource(RegistrationTest.getProperty("REGISTRATION_USER_EXISTS_MESSAGE", username)));
    }

    @Test
    public void standardRegistrationTest() {
        String username = "john" + this.suffix;
        String name = "John Doe";
        String password = "password";
        this.register(username, name, password, password);
        Assert.assertTrue((String)"Navigation after succesful registration failed.", (boolean)this.browser.getCurrentUrl().contains(RegistrationTest.getProperty("HOME_PAGE", new Object[0])));
        Assert.assertTrue((String)"Login failed.", (boolean)this.login(username, password));
        this.logout();
    }

    private void register(String username, String name, String password, String verify) {
        this.open(this.contextPath + RegistrationTest.getProperty("HOME_PAGE", new Object[0]));
        Assert.assertEquals((String)"Unable to load home page.", (Object)RegistrationTest.getProperty("PAGE_TITLE", new Object[0]), (Object)this.browser.getTitle());
        this.clickAndWaitHttp(this.getBy("REGISTRATION", new Object[0]));
        this.type(this.getBy("REGISTRATION_USERNAME", new Object[0]), username);
        this.type(this.getBy("REGISTRATION_NAME", new Object[0]), name);
        this.type(this.getBy("REGISTRATION_PASSWORD", new Object[0]), password);
        this.type(this.getBy("REGISTRATION_VERIFY", new Object[0]), verify);
        this.clickAndWaitHttp(this.getBy("REGISTRATION_SUBMIT", new Object[0]));
    }
}

