/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.booking.graphene;

import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.example.common.test.booking.graphene.BookingFunctionalTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunAsClient
@RunWith(value=Arquillian.class)
public class SimpleBookingTest
extends BookingFunctionalTestBase {
    protected final String EXPECTED_NAME = "Demo User";
    protected final String CREDIT_CARD = "0123456789012345";
    protected final String CREDIT_CARD_NAME = "visa";

    @Test
    public void invalidSearchStringTest() {
        this.enterSearchQuery("NonExistingHotel");
        Assert.assertTrue((String)"Search failed.", (boolean)this.isElementPresent(this.getBy("NO_HOTELS_FOUND", new Object[0])));
    }

    @Test
    public void simpleBookingTest() {
        String hotelName = "W Hotel";
        int confirmationNumber = this.bookHotel(hotelName);
        Assert.assertTrue((String)("Booking with confirmation number " + confirmationNumber + " not found."), (boolean)this.isElementPresent(this.getBy("BOOKING_TABLE_ITEM", confirmationNumber, hotelName)));
    }

    @Test
    public void invalidDatesTest() {
        String hotelName = "W Hotel";
        this.enterSearchQuery(hotelName);
        this.clickAndWaitHttp(this.getBy("SEARCH_RESULT_TABLE_FIRST_ROW_LINK", new Object[0]));
        this.clickAndWaitHttp(this.getBy("BOOKING_BOOK", new Object[0]));
        String checkOut = this.browser.findElement(this.getBy("HOTEL_CHECKOUT_DATE_FIELD", new Object[0])).getAttribute("value");
        this.populateBookingFields();
        this.setTextInputValue(this.getBy("HOTEL_CHECKIN_DATE_FIELD", new Object[0]), checkOut);
        this.clickAndWaitHttp(this.getBy("HOTEL_PROCEED", new Object[0]));
        Assert.assertTrue((String)"Date verification #1 failed.", (boolean)this.isTextInSource(SimpleBookingTest.getProperty("BOOKING_INVALID_DATE_MESSAGE1", new Object[0])));
        Assert.assertTrue((String)"Check-out date error message expected.", (boolean)this.isElementPresent(this.getBy("HOTEL_CHECKOUT_DATE_MESSAGE", new Object[0])));
        this.setTextInputValue(this.getBy("HOTEL_CHECKIN_DATE_FIELD", new Object[0]), "01/01/1970");
        this.clickAndWaitHttp(this.getBy("HOTEL_PROCEED", new Object[0]));
        Assert.assertTrue((String)"Date verification #2 failed.", (boolean)this.isTextInSource(SimpleBookingTest.getProperty("BOOKING_INVALID_DATE_MESSAGE2", new Object[0])));
        Assert.assertTrue((String)"Checkin-date error message expected.", (boolean)this.isElementPresent(this.getBy("HOTEL_CHECKIN_DATE_MESSAGE", new Object[0])));
    }

    @Test
    public void testJBSEAM3288() {
        int i;
        String[] hotelNames = new String[]{"Doubletree", "Hotel Rouge", "Conrad Miami"};
        int[] confirmationNumbers = new int[3];
        for (i = 0; i < 3; ++i) {
            int confirmationNumber;
            confirmationNumbers[i] = confirmationNumber = this.bookHotel(hotelNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((String)("Expected booking #" + i + " not present"), (boolean)this.isElementPresent(this.getBy("BOOKING_TABLE_ITEM", confirmationNumbers[i], hotelNames[i])));
        }
        for (i = 2; i >= 0; --i) {
            this.clickAndWaitHttp(this.getBy("BOOKING_TABLE_ITEM_LINK", confirmationNumbers[i], hotelNames[i]));
            Assert.assertTrue((String)"Booking canceling failed", (boolean)this.isTextInSource(SimpleBookingTest.getProperty("BOOKING_CANCELLED_MESSAGE", confirmationNumbers[i])));
        }
    }

    protected int bookHotel(String hotelName, int bed, int smoking, String creditCard, String creditCardName) {
        if (!this.isLoggedIn()) {
            Assert.fail();
        }
        if (!this.isElementPresent(this.getBy("SEARCH_SUBMIT", new Object[0]))) {
            this.open(this.contextPath + SimpleBookingTest.getProperty("MAIN_PAGE", new Object[0]));
        }
        this.enterSearchQuery(hotelName);
        this.clickAndWaitHttp(this.getBy("SEARCH_RESULT_TABLE_FIRST_ROW_LINK", new Object[0]));
        this.clickAndWaitHttp(this.getBy("BOOKING_BOOK", new Object[0]));
        this.populateBookingFields(bed, smoking, creditCard, creditCardName);
        this.clickAndWaitHttp(this.getBy("HOTEL_PROCEED", new Object[0]));
        this.clickAndWaitHttp(this.getBy("HOTEL_CONFIRM", new Object[0]));
        String message = this.getText(this.getBy("HOTEL_MESSAGE", new Object[0]));
        Assert.assertTrue((String)"Booking failed. Confirmation message does not match.", (boolean)message.matches(SimpleBookingTest.getProperty("BOOKING_CONFIRMATION_MESSAGE", "Demo User", hotelName)));
        String[] messageParts = message.split(" ");
        int confirmationNumber = Integer.parseInt(messageParts[messageParts.length - 1]);
        return confirmationNumber;
    }

    protected int bookHotel(String hotelName) {
        return this.bookHotel(hotelName, 2, 0, "0123456789012345", "visa");
    }

    protected void populateBookingFields(int bed, int smoking, String creditCard, String creditCardName) {
        this.selectByValue(this.getBy("HOTEL_BED_FIELD", new Object[0]), bed);
        if (smoking == 1) {
            this.click(this.getBy("HOTEL_SMOKING_1", new Object[0]));
        } else {
            this.click(this.getBy("HOTEL_SMOKING_2", new Object[0]));
        }
        this.type(this.getBy("HOTEL_CREDIT_CARD", new Object[0]), creditCard);
        this.type(this.getBy("HOTEL_CREDIT_CARD_NAME", new Object[0]), creditCardName);
    }

    protected void populateBookingFields() {
        this.populateBookingFields(2, 0, "0123456789012345", "visa");
    }
}

