/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.numberguess.graphene;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.example.common.test.DeploymentResolver;
import org.jboss.seam.example.common.test.SeamGrapheneTest;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunAsClient
@RunWith(value=Arquillian.class)
public class CommonNumberguessFunctionalTest
extends SeamGrapheneTest {
    @Deployment(testable=false)
    public static Archive<?> createDeployment() {
        return DeploymentResolver.createDeployment();
    }

    @Before
    public void setUp() {
        this.open(this.contextPath + CommonNumberguessFunctionalTest.getProperty("MAIN_PAGE", new Object[0]));
    }

    @Test
    public void smartTest() {
        int i = 0;
        while (this.browser.getCurrentUrl().contains(CommonNumberguessFunctionalTest.getProperty("GUESS_LOCATION", new Object[0]))) {
            if (i > 9) {
                Assert.fail((String)"Game should not be longer than 10 guesses");
            }
            int min = Integer.parseInt(this.getText(this.getBy("GUESS_MIN_VALUE", new Object[0])));
            int max = Integer.parseInt(this.getText(this.getBy("GUESS_MAX_VALUE", new Object[0])));
            int guess = min + (max - min) / 2;
            this.enterGuess(guess);
            ++i;
        }
        Assert.assertTrue((String)"Win page expected after playing smart.", (boolean)this.isOnWinPage());
    }

    @Test
    public void linearTest() {
        int guess = 0;
        while (this.browser.getCurrentUrl().contains(CommonNumberguessFunctionalTest.getProperty("GUESS_LOCATION", new Object[0]))) {
            this.enterGuess(++guess);
            Assert.assertTrue((String)"Guess count exceeded.", (guess <= 10 ? 1 : 0) != 0);
        }
        if (guess < 10) {
            Assert.assertTrue((String)"Player should not lose before 10th guess.", (boolean)this.isOnWinPage());
        } else {
            Assert.assertTrue((String)"After 10th guess player should lose or win.", (this.isOnLosePage() || this.isOnWinPage() ? 1 : 0) != 0);
        }
    }

    protected void enterGuess(int guess) {
        this.type(this.getBy("GUESS_FIELD", new Object[0]), String.valueOf(guess), true);
        this.clickAndWaitHttp(this.getBy("GUESS_SUBMIT", new Object[0]));
    }

    protected boolean isOnWinPage() {
        return this.browser.getCurrentUrl().contains(CommonNumberguessFunctionalTest.getProperty("WIN_LOCATION", new Object[0]));
    }

    protected boolean isOnLosePage() {
        return this.browser.getCurrentUrl().contains(CommonNumberguessFunctionalTest.getProperty("LOSE_LOCATION", new Object[0]));
    }
}

