/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.common.test.seampay.graphene;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.example.common.test.DeploymentResolver;
import org.jboss.seam.example.common.test.SeamGrapheneTest;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@RunAsClient
@RunWith(value=Arquillian.class)
public class SeampayFunctionalTest
extends SeamGrapheneTest {
    protected NumberFormat nf = NumberFormat.getNumberInstance();

    @Deployment(testable=false)
    public static Archive<?> createDeployment() {
        return DeploymentResolver.createDeployment();
    }

    @Override
    @Before
    public void beforeTest() {
        this.open(this.contextPath + SeampayFunctionalTest.getProperty("MAIN_PAGE", new Object[0]));
    }

    @Test
    public void payOnceTest() throws ParseException {
        int account = 0;
        BigDecimal amount = new BigDecimal(10);
        String to = "foo";
        this.clickAndWaitHttp(this.getBy("ACCOUNT_TABLE_LINK", account));
        BigDecimal expectedBalance = BigDecimal.valueOf(this.parseBalance(this.getText(this.getBy("ACCOUNT_TABLE_BALANCE", account))));
        this.submitPayment(to, amount.toString(), this.getBy("PAYMENT_ONLY_ONCE_RADIO", new Object[0]));
        Assert.assertTrue((String)"Scheduled payment not confirmed.", (boolean)this.isTextInSource(SeampayFunctionalTest.getProperty("PAYMENT_CONFIRMATION_MESSAGE", to)));
        Assert.assertEquals((String)"Invalid count of payments.", (long)1L, (long)this.getXpathCount(this.getBy("PAYMENTS_COUNT", new Object[0])));
        this.clickAndWaitHttp(this.getBy("ACCOUNT_TABLE_LINK", account));
        Assert.assertEquals((String)"No money were subtracted from account", (Object)expectedBalance.subtract(amount), (Object)BigDecimal.valueOf(this.parseBalance(this.getText(this.getBy("ACCOUNT_TABLE_BALANCE", account)))));
    }

    @Test
    public void payEveryMinuteTest() throws ParseException, InterruptedException {
        int account = 1;
        BigDecimal amount = new BigDecimal(10);
        String to = "foo";
        this.clickAndWaitHttp(this.getBy("ACCOUNT_TABLE_LINK", account));
        this.submitPayment(to, amount.toString(), this.getBy("PAYMENT_EVERY_MINUTE_RADIO", new Object[0]));
        Assert.assertTrue((String)"Scheduled payment not confirmed.", (boolean)this.isTextInSource(SeampayFunctionalTest.getProperty("PAYMENT_CONFIRMATION_MESSAGE", to)));
        Assert.assertEquals((String)"Invalid count of payments.", (long)1L, (long)this.getXpathCount(this.getBy("PAYMENTS_COUNT", new Object[0])));
        Thread.sleep(5000L);
        this.clickAndWaitHttp(this.getBy("ACCOUNT_TABLE_LINK", account));
        BigDecimal firstBalance = BigDecimal.valueOf(this.parseBalance(this.getText(this.getBy("ACCOUNT_TABLE_BALANCE", account))));
        Thread.sleep(60000L);
        this.clickAndWaitHttp(this.getBy("ACCOUNT_TABLE_LINK", account));
        BigDecimal secondBalance = BigDecimal.valueOf(this.parseBalance(this.getText(this.getBy("ACCOUNT_TABLE_BALANCE", account))));
        BigDecimal expectedSecondBalance = firstBalance.subtract(amount);
        Assert.assertEquals((String)"No money were subtracted from account after a minute", (Object)expectedSecondBalance, (Object)secondBalance);
    }

    protected void submitPayment(String to, String amount, By radio) {
        this.type(this.getBy("PAYMENT_TO_FIELD", new Object[0]), to);
        this.type(this.getBy("PAYMENT_AMOUNT_FIELD", new Object[0]), amount.toString());
        this.click(radio);
        this.clickAndWaitHttp(this.getBy("PAYMENT_SUBMIT", new Object[0]));
    }

    protected Double parseBalance(String text) throws ParseException {
        String number = text.replaceAll("\\$", new String()).replaceAll(" ", new String()).trim();
        return this.nf.parse(number).doubleValue();
    }
}

