/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.debug;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Contexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.debug.introspector")
@Install(debug=true, precedence=0)
public class Introspector {
    @RequestParameter
    private String name;

    public Attribute[] getAttributes() throws Exception {
        if (this.name == null) {
            return null;
        }
        Object component = Contexts.lookupInStatefulContexts((String)this.name);
        if (component == null) {
            return null;
        }
        if (component instanceof Map) {
            return this.getMapAttributes((Map)component);
        }
        if (component instanceof List) {
            return this.getListAttributes((List)component);
        }
        return this.getComponentAttributes(component);
    }

    public Attribute[] getMapAttributes(Map<Object, Object> map) {
        Attribute[] attributes = new Attribute[map.size()];
        int i = 0;
        for (Map.Entry<Object, Object> me : map.entrySet()) {
            attributes[i++] = new Attribute(me.getKey().toString(), me.getValue());
        }
        return attributes;
    }

    public Attribute[] getListAttributes(List list) {
        Attribute[] attributes = new Attribute[list.size()];
        int i = 0;
        while (i < list.size()) {
            attributes[i] = new Attribute(Integer.toString(i), list.get(i));
            ++i;
        }
        return attributes;
    }

    private Attribute[] getComponentAttributes(Object component) throws IntrospectionException, IllegalAccessException {
        String toString;
        BeanInfo bi = java.beans.Introspector.getBeanInfo(component.getClass());
        PropertyDescriptor[] properties = bi.getPropertyDescriptors();
        Attribute[] attributes = new Attribute[properties.length + 1];
        int i = 0;
        while (i < properties.length) {
            block6: {
                boolean convertArrayToList;
                List<Object> value;
                try {
                    Method readMethod = properties[i].getReadMethod();
                    if (readMethod == null) break block6;
                    value = readMethod.invoke(component, new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    Throwable e = ite.getCause();
                    value = Introspector.toString(e);
                }
                boolean bl = convertArrayToList = value != null && value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive();
                if (convertArrayToList) {
                    value = Arrays.asList((Object[])value);
                }
                attributes[i] = new Attribute(properties[i].getDisplayName(), value);
            }
            ++i;
        }
        try {
            toString = component.toString();
        }
        catch (Exception e) {
            toString = String.valueOf(e.getClass().getName()) + '[' + e.getMessage() + ']';
        }
        attributes[properties.length] = new Attribute("toString()", toString);
        return attributes;
    }

    private static String toString(Throwable e) {
        return String.valueOf(e.getClass().getName()) + '[' + e.getMessage() + ']';
    }

    public static class Attribute {
        private String name;
        private Object value;

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String getStringValue() {
            try {
                return this.value == null ? null : this.value.toString();
            }
            catch (Throwable e) {
                return Introspector.toString(e);
            }
        }
    }
}

