/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.exporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.document.DocumentStore;
import org.jboss.seam.excel.ExcelFactory;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.css.Parser;
import org.jboss.seam.excel.css.StyleMap;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.excel.exporter.excelExporter")
@Scope(value=ScopeType.EVENT)
@BypassInterceptors
public class ExcelExporter {
    private static Log log = Logging.getLog(ExcelExporter.class);
    private ExcelWorkbook excelWorkbook = null;
    private Map<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();

    public void export(String dataTableId) {
        this.export(dataTableId, "");
    }

    public void export(String dataTableId, String type) {
        this.excelWorkbook = ExcelFactory.instance().getExcelWorkbook(type);
        UIData dataTable = (UIData)FacesContext.getCurrentInstance().getViewRoot().findComponent(dataTableId);
        if (dataTable == null) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not find data table with id #0", new Object[]{dataTableId}));
        }
        UIWorkbook uiWorkbook = new UIWorkbook();
        this.excelWorkbook.createWorkbook(uiWorkbook);
        UIWorksheet uiWorksheet = new UIWorksheet();
        uiWorkbook.getChildren().add(uiWorksheet);
        uiWorksheet.setStyle(Parser.getStyle((UIComponent)dataTable));
        uiWorksheet.setStyleClass(Parser.getStyleClass((UIComponent)dataTable));
        this.excelWorkbook.createOrSelectWorksheet(uiWorksheet);
        String dataTableVar = dataTable.getVar();
        Object oldValue = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(dataTableVar);
        List<UIColumn> columns = ExcelComponent.getChildrenOfType(dataTable.getChildren(), UIColumn.class);
        this.columnWidths = this.parseColumnWidths(uiWorksheet);
        int col = 0;
        for (UIColumn column : columns) {
            uiWorksheet.getChildren().add(column);
            Iterator iterator = UIWorksheet.unwrapIterator(dataTable.getValue());
            this.processColumn(column, iterator, dataTableVar, col++);
            this.excelWorkbook.nextColumn();
        }
        if (oldValue == null) {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(dataTableVar);
        } else {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(dataTableVar, oldValue);
        }
        this.redirectExport();
    }

    private Map<Integer, Integer> parseColumnWidths(UIWorksheet worksheet) {
        HashMap<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();
        Parser parser = new Parser();
        StyleMap styleMap = parser.getCascadedStyleMap((UIComponent)worksheet);
        for (Map.Entry entry : styleMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("xls-column-widths")) continue;
            String columnIndexString = key.substring("xls-column-widths".length());
            int columnIndex = Integer.parseInt(columnIndexString);
            columnWidths.put(columnIndex, (Integer)entry.getValue());
        }
        return columnWidths;
    }

    private void redirectExport() {
        String viewId = Pages.getViewId((FacesContext)FacesContext.getCurrentInstance());
        String baseName = UIWorkbook.baseNameForViewId(viewId);
        DocumentData documentData = new DocumentData(baseName, this.excelWorkbook.getDocumentType(), this.excelWorkbook.getBytes());
        String id = DocumentStore.instance().newId();
        String url = DocumentStore.instance().preferredUrlForContent(baseName, this.excelWorkbook.getDocumentType().getExtension(), id);
        url = Manager.instance().encodeConversationId(url, viewId);
        DocumentStore.instance().saveData(id, documentData);
        try {
            FacesContext.getCurrentInstance().getExternalContext().redirect(url);
        }
        catch (IOException e) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not redirect to #0", new Object[]{url}), e);
        }
    }

    private void processColumn(UIColumn column, Iterator iterator, String var, int columnIndex) {
        UIComponent headerFacet = column.getFacet("header");
        if (headerFacet != null && UIOutput.class.isAssignableFrom(headerFacet.getClass())) {
            ArrayList<UIOutput> headerOutputs = new ArrayList<UIOutput>();
            headerOutputs.add((UIOutput)headerFacet);
            this.processOutputs(column, headerOutputs);
        }
        while (iterator.hasNext()) {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(var, iterator.next());
            List<UIOutput> dataOutputs = ExcelComponent.getChildrenOfType(column.getChildren(), UIOutput.class);
            this.processOutputs(column, dataOutputs);
        }
        Integer columnWidth = this.columnWidths.get(columnIndex);
        if (columnWidth != null) {
            org.jboss.seam.excel.ui.UIColumn uiColumn = new org.jboss.seam.excel.ui.UIColumn();
            uiColumn.setStyle("xls-column-width:" + columnWidth);
            this.excelWorkbook.applyColumnSettings(uiColumn);
        }
    }

    private void processOutputs(UIColumn column, List<UIOutput> outputs) {
        for (UIOutput output : outputs) {
            if (!output.isRendered()) continue;
            UICell cell = new UICell();
            column.getChildren().add(cell);
            cell.setId(output.getId());
            cell.setValue(output.getValue());
            cell.setStyle(Parser.getStyle((UIComponent)output));
            cell.setStyleClass(Parser.getStyleClass((UIComponent)output));
            this.excelWorkbook.addItem(cell);
        }
    }
}

