/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.flex;

import flex.messaging.FlexContext;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.Message;
import flex.messaging.services.remoting.adapters.JavaAdapter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;

public class SeamAdapter
extends JavaAdapter {
    public static final String SEAM_ADAPTER_ID = "seam-adapter";
    private static final String CONVERSATION_ID = "conversationId";
    private static final LogProvider log = Logging.getLogProvider(SeamAdapter.class);

    public Object invoke(Message message) {
        log.info((Object)("SeamAdapter: " + message));
        try {
            this.startSeamContexts(message, FlexContext.getHttpRequest());
            Object result = this.wrapResult(super.invoke(message));
            this.endSeamContexts(FlexContext.getHttpRequest());
            return result;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected Object wrapResult(Object result) {
        AcknowledgeMessage response = new AcknowledgeMessage();
        response.setHeader(CONVERSATION_ID, (Object)Manager.instance().getCurrentConversationId());
        response.setBody(result);
        return response;
    }

    protected void startSeamContexts(Message message, HttpServletRequest request) {
        ServletLifecycle.beginRequest((HttpServletRequest)request);
        ServletContexts.instance().setRequest(request);
        Map conversationParameters = this.conversationMap(message);
        ConversationPropagation.instance().restoreConversationId(conversationParameters);
        Manager.instance().restoreConversation();
        ServletLifecycle.resumeConversation((HttpServletRequest)request);
        Manager.instance().handleConversationPropagation(conversationParameters);
        if (request.getSession(false) == null) {
            request.getSession(true);
        }
    }

    protected void endSeamContexts(HttpServletRequest request) {
        Manager.instance().endRequest((Map)new ServletRequestSessionMap(request));
        ServletLifecycle.endRequest((HttpServletRequest)request);
    }

    protected Map conversationMap(Message message) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(Manager.instance().getConversationIdParameter(), this.conversationId(message));
        return result;
    }

    protected String conversationId(Message message) {
        if (message == null) {
            return null;
        }
        Object header = message.getHeader(CONVERSATION_ID);
        return header == null ? null : header.toString();
    }
}

