/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.ApplicationConfig;
import org.resteasy.Dispatcher;
import org.resteasy.plugins.providers.RegisterBuiltin;
import org.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.InjectorFactory;
import org.resteasy.spi.PropertyInjector;
import org.resteasy.spi.Registry;
import org.resteasy.spi.ResourceFactory;
import org.resteasy.spi.ResteasyProviderFactory;

@Name(value="org.jboss.seam.resteasy.dispatcher")
@Scope(value=ScopeType.APPLICATION)
@Startup(depends={"resteasyBootstrap"})
@AutoCreate
@Install(classDependencies={"org.resteasy.Dispatcher"})
public class ResteasyDispatcher
extends HttpServletDispatcher {
    @In
    ApplicationConfig applicationConfig;
    @Logger
    Log log;

    @Create
    public void onStartup() {
        Component seamComponent;
        this.log.debug((Object)"assigning registered RESTEasy resources and providers", new Object[0]);
        ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();
        ResteasyProviderFactory.setInstance((ResteasyProviderFactory)providerFactory);
        this.setDispatcher(new Dispatcher(providerFactory));
        this.getDispatcher().setLanguageMappings(this.applicationConfig.getLanguageMappings());
        this.getDispatcher().setMediaTypeMappings(this.applicationConfig.getMediaTypeMappings());
        Registry registry = this.getDispatcher().getRegistry();
        for (final Class<?> resourceClass : this.applicationConfig.getResourceClasses()) {
            seamComponent = this.applicationConfig.getResourceClassComponent(resourceClass);
            if (seamComponent != null) {
                registry.addResourceFactory(new ResourceFactory(){
                    private PropertyInjector propertyInjector;

                    public Class<?> getScannableClass() {
                        return resourceClass;
                    }

                    public void registered(InjectorFactory factory) {
                        this.propertyInjector = factory.createPropertyInjector(this.getScannableClass());
                    }

                    public Object createResource(HttpRequest request, HttpResponse response, InjectorFactory factory) {
                        Object target = Component.getInstance((String)seamComponent.getName());
                        this.propertyInjector.inject(request, response, target);
                        return target;
                    }

                    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
                    }

                    public void unregistered() {
                    }
                });
                continue;
            }
            registry.addResourceFactory((ResourceFactory)new POJOResourceFactory(resourceClass));
        }
        if (this.applicationConfig.isUseBuiltinProviders()) {
            this.log.info((Object)"registering built-in RESTEasy providers", new Object[0]);
            RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        }
        for (Class<?> providerClass : this.applicationConfig.getProviderClasses()) {
            seamComponent = this.applicationConfig.getProviderClassComponent(providerClass);
            if (seamComponent != null) {
                if (ScopeType.STATELESS.equals((Object)seamComponent.getScope())) {
                    throw new RuntimeException("Registration of STATELESS Seam components as RESTEasy providers not implemented!");
                }
                if (!ScopeType.APPLICATION.equals((Object)seamComponent.getScope())) continue;
                Object providerInstance = Component.getInstance((String)seamComponent.getName());
                providerFactory.registerProviderInstance(providerInstance);
                continue;
            }
            providerFactory.registerProvider(providerClass);
        }
    }
}

