/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rss.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.rss.ui.SyndicationComponent;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.io.FeedWriter;

public class UIFeed
extends SyndicationComponent {
    private static final String COMPONENT_TYPE = "org.jboss.seam.rss.ui.UIFeed";
    private static final String EXTENSION = "xml";
    private static final String MIMETYPE = "text/xml";
    private boolean sendRedirect = true;
    private String uid;
    private String title;
    private String subtitle;
    private Date updated;
    private String link;
    private FeedFormat feedFormat = FeedFormat.ATOM10;

    public void encodeBegin(FacesContext facesContext) throws IOException {
        ChannelFeed channelFeed = new ChannelFeed();
        channelFeed.setUid(this.getUid());
        channelFeed.setTitle(this.getTitle());
        channelFeed.setDescriptionOrSubtitle(this.getSubtitle());
        if (this.getUpdated() != null) {
            channelFeed.setPubDate(this.getUpdated(), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        }
        channelFeed.addLink(new String[]{this.getLink()});
        Contexts.getEventContext().set("theFeed", (Object)channelFeed);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        ChannelFeed channelFeed = (ChannelFeed)Contexts.getEventContext().get("theFeed");
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            FeedWriter.writeChannel((FeedFormat)this.feedFormat, (ChannelFeed)channelFeed, (OutputStream)byteStream);
        }
        catch (YarfrawException e) {
            throw new RuntimeException("Could not create feed", e);
        }
        PrintWriter responseWriter = ((HttpServletResponse)facesContext.getExternalContext().getResponse()).getWriter();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType(MIMETYPE);
        response.setContentLength(byteStream.size());
        ((Writer)responseWriter).write(byteStream.toString());
        response.flushBuffer();
        facesContext.responseComplete();
    }

    public static String baseNameForViewId(String viewId) {
        int pos = viewId.lastIndexOf("/");
        if (pos != -1) {
            viewId = viewId.substring(pos + 1);
        }
        if ((pos = viewId.lastIndexOf(".")) != -1) {
            viewId = viewId.substring(0, pos);
        }
        return viewId;
    }

    public boolean isSendRedirect() {
        return this.sendRedirect;
    }

    public void setSendRedirect(boolean sendRedirect) {
        this.sendRedirect = sendRedirect;
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public String getTitle() {
        return (String)this.valueOf("title", this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return (String)this.valueOf("subtitle", this.subtitle);
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Date getUpdated() {
        return (Date)this.valueOf("updated", this.updated);
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public String getLink() {
        return (String)this.valueOf("link", this.link);
    }

    public void setLink(String link) {
        this.link = link;
    }

    public FeedFormat getFeedFormat() {
        return (FeedFormat)this.valueOf("feedFormat", this.feedFormat);
    }

    public void setFeedFormat(FeedFormat feedFormat) {
        this.feedFormat = feedFormat;
    }

    public String getUid() {
        return (String)this.valueOf("uid", this.uid);
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}

