/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.component;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionListener;
import javax.faces.model.DataModel;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.ui.component.UIAction;
import org.jboss.seam.ui.component.UIConversationId;
import org.jboss.seam.ui.component.UIConversationPropagation;
import org.jboss.seam.ui.component.UISelection;
import org.jboss.seam.ui.component.UITaskId;
import org.jboss.seam.ui.util.ViewUrlBuilder;
import org.jboss.seam.ui.util.cdk.MethodBindingToMethodExpression;
import org.jboss.seam.ui.util.cdk.MethodExpressionToMethodBinding;

public abstract class UISeamCommandBase
extends UIOutput
implements ActionSource2 {
    public abstract String getView();

    public String getUrl() throws UnsupportedEncodingException {
        UISelection uiSelection;
        ValueExpression taskInstanceValueExpression;
        FacesContext context = this.getFacesContext();
        String viewId = this.getView();
        if (viewId == null) {
            viewId = Pages.getViewId((FacesContext)this.getFacesContext());
        }
        ViewUrlBuilder url = new ViewUrlBuilder(viewId, this.getFragment());
        HashSet<String> usedParameters = new HashSet<String>();
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            usedParameters.add(((UIParameter)child).getName());
            url.addParameter((UIParameter)child);
        }
        if (viewId != null) {
            Map pageParameters = Pages.instance().getStringValuesFromModel(context, viewId, usedParameters);
            for (Map.Entry me : pageParameters.entrySet()) {
                UIParameter uip = new UIParameter();
                uip.setName((String)me.getKey());
                uip.setValue(me.getValue());
                url.addParameter(uip);
            }
        }
        if (this.getActionExpression() != null) {
            UIAction uiAction = new UIAction();
            uiAction.setAction(this.getActionExpression().getExpressionString());
            url.addParameter(uiAction);
        }
        if ("default".equals(this.getPropagation()) || "join".equals(this.getPropagation()) || "nest".equals(this.getPropagation()) || "end".equals(this.getPropagation())) {
            UIConversationId uiConversationId = UIConversationId.newInstance();
            uiConversationId.setViewId(viewId);
            url.addParameter(uiConversationId);
        }
        if ("join".equals(this.getPropagation()) || "nest".equals(this.getPropagation()) || "begin".equals(this.getPropagation()) || "end".equals(this.getPropagation())) {
            UIConversationPropagation uiPropagation = UIConversationPropagation.newInstance();
            uiPropagation.setType(this.getPropagation());
            uiPropagation.setPageflow(this.getPageflow());
            url.addParameter(uiPropagation);
        }
        if ((taskInstanceValueExpression = this.getValueExpression("taskInstance")) != null) {
            UITaskId uiTaskId = UITaskId.newInstance();
            uiTaskId.setValueExpression("taskInstance", taskInstanceValueExpression);
            url.addParameter(uiTaskId);
        }
        if ((uiSelection = this.getSelection()) != null) {
            url.addParameter(uiSelection);
        }
        String encodedUrl = url.getEncodedUrl();
        return encodedUrl;
    }

    public abstract void setView(String var1);

    public abstract String getPropagation();

    public abstract void setPropagation(String var1);

    public abstract String getPageflow();

    public abstract void setPageflow(String var1);

    public abstract String getFragment();

    public abstract void setFragment(String var1);

    public UISelection getSelection() {
        UIData parentUIData = this.getParentUIData();
        if (parentUIData != null) {
            if (parentUIData.getValue() instanceof DataModel) {
                String dataModelExpression = parentUIData.getValueExpression("value").getExpressionString();
                String dataModelName = dataModelExpression.substring(2, dataModelExpression.length() - 1).replace('$', '.');
                UISelection uiSelection = UISelection.newInstance();
                uiSelection.setDataModel(dataModelName);
                uiSelection.setVar(parentUIData.getVar());
                return uiSelection;
            }
            return null;
        }
        return null;
    }

    public UIData getParentUIData() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            return (UIData)parent;
        }
        return null;
    }

    public void removeActionListener(ActionListener listener) {
        throw new UnsupportedOperationException("Action listeners not supported by s:link/s:button");
    }

    public ActionListener[] getActionListeners() {
        throw new UnsupportedOperationException("Action listeners not supported by s:link/s:button");
    }

    public void addActionListener(ActionListener listener) {
        throw new UnsupportedOperationException("Action listeners not supported by s:link/s:button");
    }

    @Deprecated
    public void setAction(MethodBinding methodBinding) {
        this.setActionExpression(new MethodBindingToMethodExpression(methodBinding));
    }

    @Deprecated
    public MethodBinding getAction() {
        return new MethodExpressionToMethodBinding(this.getActionExpression());
    }
}

