/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.converter;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.framework.EntityIdentifier;
import org.jboss.seam.framework.MutableEntityController;

@Name(value="org.jboss.seam.ui.entityConverterStore")
@Install(precedence=0)
@Scope(value=ScopeType.PAGE)
public class EntityConverterStore
extends MutableEntityController {
    private List<EntityIdentifier> store = new ArrayList<EntityIdentifier>();

    @Transactional
    public Object get(Integer key) {
        try {
            return this.store.get(key).find(this.getEntityManager());
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Transactional
    public Integer put(Object entity) {
        EntityIdentifier key = new EntityIdentifier(entity, this.getEntityManager());
        if (!this.store.contains(key)) {
            this.store.add(key);
            this.setDirty();
        }
        return this.store.indexOf(key);
    }

    public static EntityConverterStore instance() {
        if (!Contexts.isPageContextActive()) {
            throw new IllegalArgumentException("Page scope not active");
        }
        return (EntityConverterStore)((Object)Component.getInstance(EntityConverterStore.class));
    }

    public EntityManager getEntityManager() {
        if (!super.getEntityManager().isOpen()) {
            super.setEntityManager(null);
        }
        return super.getEntityManager();
    }
}

