/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.ui.util.cdk.RendererBase;

public class DefaultActionRendererBase
extends RendererBase {
    public static final String MARK = "org.jboss.seam.ui.DefaultAction";
    private static LogProvider log = Logging.getLogProvider(DefaultActionRendererBase.class);

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIComponent actionComponent = component.getParent();
        String actionComponentId = actionComponent.getClientId(context);
        UIForm form = DefaultActionRendererBase.getUtils().getForm(actionComponent);
        if (form == null) {
            log.warn((Object)"Must embed default action inside a form");
        } else {
            String formId = form.getClientId(context);
            writer.startElement("script", component);
            writer.writeAttribute("language", (Object)"JavaScript", "language");
            writer.writeAttribute("type", (Object)"text/javascript", "type");
            if (actionComponent.getId().startsWith("j_id")) {
                log.warn((Object)"Must set an id for the default action source");
            }
            if (form.getAttributes().containsKey(MARK)) {
                if (!form.getAttributes().get(MARK).equals(component.getClientId(context))) {
                    log.warn((Object)"Can only specify one default action per form");
                }
            } else {
                form.getAttributes().put(MARK, component.getClientId(context));
            }
            String functionBody = "{var keycode;if (window.event) keycode = window.event.keyCode;else if (event) keycode = event.which;else return true;if (keycode == 13) { document.getElementById('" + actionComponentId + "').click();return false; } " + "else return true; }";
            String functionCode = "document.forms['" + formId + "'].onkeypress = " + "new Function(\"event\", \"" + functionBody + "\");";
            writer.write(functionCode);
            writer.endElement("script");
        }
    }

    protected Class getComponentClass() {
        return UIOutput.class;
    }
}

