/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.converter;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.faces.Converter;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.ui.converter.entityConverter.AbstractEntityLoader;
import org.jboss.seam.ui.converter.entityConverter.EntityLoader;
import org.jboss.seam.ui.converter.entityConverter.HibernateEntityLoader;

@Name(value="org.jboss.seam.ui.EntityConverter")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=0)
@Converter
@BypassInterceptors
public class EntityConverter
implements javax.faces.convert.Converter,
Serializable {
    private Expressions.ValueExpression entityManager;
    private Expressions.ValueExpression session;
    private AbstractEntityLoader store;

    @Create
    public void create() {
        this.store = this.getEntityManager() == null && this.getSession() != null ? HibernateEntityLoader.instance() : EntityLoader.instance();
    }

    private void init() {
        if (this.getPersistenceContext() != null) {
            this.store.setPersistenceContext(this.getPersistenceContext().getValue());
        }
    }

    @Transactional
    public String getAsString(FacesContext facesContext, UIComponent cmp, Object value) throws ConverterException {
        this.init();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return this.store.put(value);
    }

    @Transactional
    public Object getAsObject(FacesContext facesContext, UIComponent cmp, String value) throws ConverterException {
        this.init();
        if (value == null) {
            return null;
        }
        return this.store.get(value);
    }

    public Expressions.ValueExpression getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(Expressions.ValueExpression entityManager) {
        this.entityManager = entityManager;
    }

    public Expressions.ValueExpression getSession() {
        return this.session;
    }

    public void setSession(Expressions.ValueExpression session) {
        this.session = session;
    }

    private Expressions.ValueExpression getPersistenceContext() {
        if (this.getEntityManager() != null) {
            return this.getEntityManager();
        }
        return this.getSession();
    }
}

