/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletRequest;
import org.jboss.seam.ui.component.UIFileUpload;
import org.jboss.seam.ui.util.HTML;
import org.jboss.seam.ui.util.cdk.RendererBase;
import org.jboss.seam.web.MultipartRequest;

public class FileUploadRendererBase
extends RendererBase {
    protected Class getComponentClass() {
        return UIFileUpload.class;
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIFileUpload fileUpload = (UIFileUpload)component;
        writer.startElement("input", (UIComponent)fileUpload);
        writer.writeAttribute("type", (Object)"file", null);
        String clientId = fileUpload.getClientId(context);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        HTML.renderHTMLAttributes(writer, component, HTML.INPUT_FILE_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        writer.endElement("input");
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        UIFileUpload fileUpload = (UIFileUpload)component;
        ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
        if (!(request instanceof MultipartRequest)) {
            request = FileUploadRendererBase.unwrapMultipartRequest(request);
        }
        if (request instanceof MultipartRequest) {
            MultipartRequest multipartRequest = (MultipartRequest)request;
            String clientId = component.getClientId(context);
            fileUpload.setLocalInputStream(multipartRequest.getFileInputStream(clientId));
            fileUpload.setLocalContentType(multipartRequest.getFileContentType(clientId));
            fileUpload.setLocalFileName(multipartRequest.getFileName(clientId));
            fileUpload.setLocalFileSize(multipartRequest.getFileSize(clientId));
        }
    }

    private static ServletRequest unwrapMultipartRequest(ServletRequest request) {
        while (!(request instanceof MultipartRequest)) {
            boolean found = false;
            AccessibleObject[] accessibleObjectArray = request.getClass().getMethods();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = accessibleObjectArray[n2];
                if (ServletRequest.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 0) {
                    try {
                        request = (ServletRequest)m.invoke((Object)request, new Object[0]);
                        found = true;
                        break;
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            if (!found) {
                accessibleObjectArray = request.getClass().getDeclaredFields();
                n = accessibleObjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    AccessibleObject f = accessibleObjectArray[n2];
                    if (ServletRequest.class.isAssignableFrom(((Field)f).getType())) {
                        try {
                            request = (ServletRequest)((Field)f).get(request);
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
            }
            if (!found) break;
        }
        return request;
    }
}

