/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UISelectItems;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;

/**
 * Creates a List<SelectItem> from a List, Set, DataModel or Array.
 **/
@Generated({"RichFaces CDK", "4.2.2.Final"})
public class HtmlSelectItems extends UISelectItems
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.SelectItems";

    public static final String COMPONENT_FAMILY="javax.faces.SelectItems";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }






    protected enum Properties {
        action,
        actionExpression,
        actionListener,
        disabled,
        escape,
        hideNoSelectionLabel,
        immediate,
        itemValue,
        noSelectionLabel,
        var
        
    }

 
    public MethodBinding getAction() {
        MethodBinding value = (MethodBinding) getStateHelper().get(Properties.action);
        return value;
    }
    
    public void setAction(MethodBinding action) {
        getStateHelper().put(Properties.action, action);
    }

 
    public MethodExpression getActionExpression() {
        MethodExpression value = (MethodExpression) getStateHelper().get(Properties.actionExpression);
        return value;
    }
    
    public void setActionExpression(MethodExpression actionExpression) {
        getStateHelper().put(Properties.actionExpression, actionExpression);
    }

 
    public MethodBinding getActionListener() {
        MethodBinding value = (MethodBinding) getStateHelper().get(Properties.actionListener);
        return value;
    }
    
    public void setActionListener(MethodBinding actionListener) {
        getStateHelper().put(Properties.actionListener, actionListener);
    }

 
    public Boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled);
        return value;
    }
    
    public void setDisabled(Boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public Boolean isEscape() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.escape, true);
        return value;
    }
    
    public void setEscape(Boolean escape) {
        getStateHelper().put(Properties.escape, escape);
    }

 
    public Boolean isHideNoSelectionLabel() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.hideNoSelectionLabel, false);
        return value;
    }
    
    public void setHideNoSelectionLabel(Boolean hideNoSelectionLabel) {
        getStateHelper().put(Properties.hideNoSelectionLabel, hideNoSelectionLabel);
    }

 
    public boolean isImmediate() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.immediate, Boolean.FALSE);
        return value;
    }
    
    public void setImmediate(boolean immediate) {
        getStateHelper().put(Properties.immediate, immediate);
    }

 
    public Object getItemValue() {
        Object value = (Object) getStateHelper().eval(Properties.itemValue);
        return value;
    }
    
    public void setItemValue(Object itemValue) {
        getStateHelper().put(Properties.itemValue, itemValue);
    }

 
    public String getNoSelectionLabel() {
        String value = (String) getStateHelper().eval(Properties.noSelectionLabel);
        return value;
    }
    
    public void setNoSelectionLabel(String noSelectionLabel) {
        getStateHelper().put(Properties.noSelectionLabel, noSelectionLabel);
    }

 
    public String getVar() {
        String value = (String) getStateHelper().eval(Properties.var);
        return value;
    }
    
    public void setVar(String var) {
        getStateHelper().put(Properties.var, var);
    }

    

}