/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.maven.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.maven.plugin.logging.Log;
import org.jboss.seam.maven.helper.XMLGenerator;
import org.w3c.dom.Element;

public class ValidatorGenerator {
    private List<File> validatorXMLs = new ArrayList<File>();
    private Log log;
    private String targetDirectory;
    private Map<String, String> validatorNames = new HashMap<String, String>();

    public ValidatorGenerator(String targetDirectory, Log log) {
        this.targetDirectory = targetDirectory;
        this.log = log;
        this.validatorNames.put("formattedTextValidator.xml", "validateFormattedText");
        this.validatorNames.put("modelValidator.xml", "validate");
    }

    public void addFile(File file) throws FileNotFoundException {
        if (this.fileIsValidatorXML(file)) {
            this.validatorXMLs.add(file);
        }
    }

    private boolean fileIsValidatorXML(File file) throws FileNotFoundException {
        Scanner scanner;
        String find;
        if (file.getName().endsWith(".xml") && (find = (scanner = new Scanner(file)).findWithinHorizon("<validator>", 0)) != null) {
            this.log.info((CharSequence)("Identified " + file.getName() + " as Validator XML"));
            return true;
        }
        return false;
    }

    public void generateValidators() throws Exception {
        this.log.info((CharSequence)"Generating Validators");
        XMLGenerator xmlGenerator = new XMLGenerator(this.log);
        File outXML = new File(this.targetDirectory + "/generated-sources/main/resources/META-INF", "s.taglib.xml");
        ArrayList<Element> tagsToAdd = new ArrayList<Element>();
        for (File xml : this.validatorXMLs) {
            Element tag = xmlGenerator.getFaceletsTagElementFromFacesconfig(xml, this.validatorNames.get(xml.getName()), "validator");
            tagsToAdd.add(tag);
        }
        xmlGenerator.updateFile(outXML, tagsToAdd);
    }
}

