/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.exception.handler;

import java.lang.reflect.Method;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.seam.exception.control.CaughtException;
import org.jboss.seam.servlet.exception.handler.SendErrorPage;
import org.jboss.seam.servlet.exception.handler.SendHttpError;
import org.jboss.seam.servlet.http.HttpServletRequestContext;

public class ExceptionResponseServiceHandler {
    @Inject
    private Instance<HttpServletRequestContext> requestCtxResolver;

    @AroundInvoke
    public Object processException(InvocationContext ctx) throws Exception {
        Method m = ctx.getMethod();
        if (ctx.getParameters().length > 0 && ctx.getParameters()[0] instanceof CaughtException) {
            HttpServletRequestContext requestCtx = (HttpServletRequestContext)this.requestCtxResolver.get();
            if (requestCtx.getResponse().isCommitted()) {
                return Void.TYPE;
            }
            CaughtException c = (CaughtException)ctx.getParameters()[0];
            if (m.isAnnotationPresent(SendHttpError.class)) {
                SendHttpError r = m.getAnnotation(SendHttpError.class);
                String message = r.message().trim();
                if (r.message().length() == 0 && r.useExceptionMessageAsDefault()) {
                    message = c.getException().getMessage();
                }
                if (message != null && message.length() > 0) {
                    requestCtx.getResponse().sendError(r.status(), message);
                } else {
                    requestCtx.getResponse().sendError(r.status());
                }
            } else if (m.isAnnotationPresent(SendErrorPage.class)) {
                SendErrorPage r = m.getAnnotation(SendErrorPage.class);
                if (r.redirect()) {
                    requestCtx.getResponse().sendRedirect(requestCtx.getResponse().encodeRedirectURL(r.value()));
                } else {
                    requestCtx.getRequest().getRequestDispatcher(r.value()).forward((ServletRequest)requestCtx.getRequest(), (ServletResponse)requestCtx.getResponse());
                }
            }
        }
        return Void.TYPE;
    }
}

