/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.servlet.http.Cookie;
import org.jboss.seam.servlet.http.CookieParam;
import org.jboss.seam.servlet.http.CookieParamProducer;
import org.jboss.seam.servlet.http.HeaderParam;
import org.jboss.seam.servlet.http.HeaderParamProducer;
import org.jboss.seam.servlet.http.RequestParam;
import org.jboss.seam.servlet.http.RequestParamProducer;
import org.jboss.seam.servlet.http.TemporalConverters;
import org.jboss.seam.servlet.http.TypedParamValue;
import org.jboss.seam.servlet.http.literal.CookieParamLiteral;
import org.jboss.seam.servlet.http.literal.HeaderParamLiteral;
import org.jboss.seam.servlet.http.literal.RequestParamLiteral;
import org.jboss.seam.servlet.support.ServletMessages;
import org.jboss.seam.solder.bean.NarrowingBeanBuilder;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.jboss.seam.solder.messages.Messages;
import org.jboss.seam.solder.reflection.PrimitiveTypes;

public class ServletExtension
implements Extension {
    private transient ServletMessages messages = (ServletMessages)Messages.getBundle(ServletMessages.class);
    private final Map<Class<? extends Annotation>, TypedParamProducerBlueprint> producerBlueprints = new HashMap<Class<? extends Annotation>, TypedParamProducerBlueprint>();
    private final Map<Class<?>, Member> converterMembersByType;

    ServletExtension() {
        this.producerBlueprints.put(RequestParam.class, new TypedParamProducerBlueprint((Annotation)RequestParamLiteral.INSTANCE));
        this.producerBlueprints.put(HeaderParam.class, new TypedParamProducerBlueprint((Annotation)HeaderParamLiteral.INSTANCE));
        this.producerBlueprints.put(CookieParam.class, new TypedParamProducerBlueprint((Annotation)CookieParamLiteral.INSTANCE));
        this.converterMembersByType = new HashMap();
    }

    public Member getConverterMember(Class<?> type) {
        return this.converterMembersByType.get(type);
    }

    void processRequestParamProducer(@Observes ProcessProducerMethod<Object, RequestParamProducer> event) {
        if (event.getAnnotatedProducerMethod().getBaseType().equals(Object.class) && event.getAnnotatedProducerMethod().isAnnotationPresent(TypedParamValue.class)) {
            this.producerBlueprints.get(RequestParam.class).setProducer(event.getBean());
        }
    }

    @Deprecated
    void processRequestParamProducerInverted(@Observes ProcessProducerMethod<RequestParamProducer, Object> event) {
        if (this.isTypedParamProducer(event.getAnnotatedProducerMethod())) {
            this.producerBlueprints.get(RequestParam.class).setProducer(event.getBean());
        }
    }

    void processHeaderParamProducer(@Observes ProcessProducerMethod<Object, HeaderParamProducer> event) {
        if (this.isTypedParamProducer(event.getAnnotatedProducerMethod())) {
            this.producerBlueprints.get(HeaderParam.class).setProducer(event.getBean());
        }
    }

    @Deprecated
    void processHeaderParamProducerInverted(@Observes ProcessProducerMethod<HeaderParamProducer, Object> event) {
        if (this.isTypedParamProducer(event.getAnnotatedProducerMethod())) {
            this.producerBlueprints.get(HeaderParam.class).setProducer(event.getBean());
        }
    }

    void processCookieParamProducer(@Observes ProcessProducerMethod<Object, CookieParamProducer> event) {
        if (this.isTypedParamProducer(event.getAnnotatedProducerMethod())) {
            this.producerBlueprints.get(CookieParam.class).setProducer(event.getBean());
        }
    }

    @Deprecated
    void processCookieParamProducerInverted(@Observes ProcessProducerMethod<CookieParamProducer, Object> event) {
        if (this.isTypedParamProducer(event.getAnnotatedProducerMethod())) {
            this.producerBlueprints.get(CookieParam.class).setProducer(event.getBean());
        }
    }

    <X> void detectInjections(@Observes ProcessInjectionTarget<X> event) {
        block4: for (InjectionPoint ip : event.getInjectionTarget().getInjectionPoints()) {
            Annotated annotated = ip.getAnnotated();
            for (Class<? extends Annotation> paramAnnotationType : this.producerBlueprints.keySet()) {
                if (!annotated.isAnnotationPresent(paramAnnotationType)) continue;
                List<Annotation> allowed = Arrays.asList(DefaultLiteral.INSTANCE, AnyLiteral.INSTANCE, annotated.getAnnotation(paramAnnotationType));
                boolean error = false;
                for (Annotation q : ip.getQualifiers()) {
                    if (allowed.contains(q)) continue;
                    event.addDefinitionError((Throwable)new IllegalArgumentException(this.messages.additionalQualifiersNotPermitted(paramAnnotationType.getSimpleName(), ip)));
                    error = true;
                    break;
                }
                if (error) continue block4;
                Type targetType = this.getActualBeanType(ip.getType());
                if (!(targetType instanceof Class)) {
                    event.addDefinitionError((Throwable)new IllegalArgumentException(this.messages.rawTypeRequired(paramAnnotationType.getSimpleName(), ip)));
                    continue block4;
                }
                try {
                    Class targetClass = (Class)targetType;
                    if (!(targetClass.equals(String.class) || paramAnnotationType.equals(CookieParam.class) && targetClass.equals(Cookie.class))) {
                        targetClass = PrimitiveTypes.box((Class)targetClass);
                        Executable converter = null;
                        if (targetClass.isEnum()) {
                            converter = targetClass.getMethod("valueOf", String.class);
                        } else if (Date.class.isAssignableFrom(targetClass)) {
                            converter = TemporalConverters.class.getMethod("parseDate", String.class);
                        } else if (Calendar.class.isAssignableFrom(targetClass)) {
                            converter = TemporalConverters.class.getMethod("parseCalendar", String.class);
                        } else {
                            try {
                                converter = targetClass.getConstructor(String.class);
                            }
                            catch (NoSuchMethodException sce) {
                                converter = targetClass.getMethod("valueOf", String.class);
                            }
                        }
                        this.converterMembersByType.put(targetClass, converter);
                    }
                    this.producerBlueprints.get(paramAnnotationType).addTargetType(targetClass);
                }
                catch (NoSuchMethodException nme) {
                    event.addDefinitionError((Throwable)new IllegalArgumentException(this.messages.noConverterForType(paramAnnotationType.getSimpleName(), ip)));
                }
            }
        }
    }

    void installBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (TypedParamProducerBlueprint blueprint : this.producerBlueprints.values()) {
            if (blueprint.getProducer() == null) continue;
            for (Class<?> type : blueprint.getTargetTypes()) {
                event.addBean(this.createTypedParamProducer(blueprint.getProducer(), type, blueprint.getQualifier(), beanManager));
            }
        }
        this.producerBlueprints.clear();
    }

    private boolean isTypedParamProducer(AnnotatedMethod<?> method) {
        return method.getBaseType().equals(Object.class) && method.isAnnotationPresent(TypedParamValue.class);
    }

    private <T> Bean<T> createTypedParamProducer(Bean<Object> delegate, Class<T> targetType, Annotation qualifier, BeanManager beanManager) {
        return new NarrowingBeanBuilder(delegate, beanManager).readFromType(beanManager.createAnnotatedType(targetType)).qualifiers(new Annotation[]{qualifier}).create();
    }

    private Type getActualBeanType(Type t) {
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getRawType().equals(Instance.class)) {
            return ((ParameterizedType)t).getActualTypeArguments()[0];
        }
        return t;
    }

    public static class TypedParamProducerBlueprint {
        private Bean<Object> producer;
        private Set<Class<?>> targetTypes;
        private Annotation qualifier;

        public TypedParamProducerBlueprint(Annotation qualifier) {
            this.qualifier = qualifier;
            this.targetTypes = new HashSet();
        }

        public Bean<Object> getProducer() {
            return this.producer;
        }

        public void setProducer(Bean producer) {
            this.producer = producer;
        }

        public Set<Class<?>> getTargetTypes() {
            return this.targetTypes;
        }

        public void addTargetType(Class<?> targetType) {
            this.targetTypes.add(targetType);
        }

        public Annotation getQualifier() {
            return this.qualifier;
        }
    }
}

