/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.event;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.seam.servlet.WebApplication;
import org.jboss.seam.servlet.event.AbstractServletEventBridge;
import org.jboss.seam.servlet.event.literal.DestroyedLiteral;
import org.jboss.seam.servlet.event.literal.StartedLiteral;

public class ServletEventBridgeServlet
extends AbstractServletEventBridge
implements Servlet {
    private transient ServletConfig config;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.fireWebApplicationEvent(StartedLiteral.INSTANCE);
    }

    public void destroy() {
        if (this.config != null) {
            this.fireWebApplicationEvent(DestroyedLiteral.INSTANCE);
            this.fireEvent(this.config.getServletContext(), DestroyedLiteral.INSTANCE);
        }
    }

    protected void fireWebApplicationEvent(Annotation qualifier) {
        if (this.config.getServletContext().getAttribute(WEB_APPLICATION_ATTRIBUTE_NAME) instanceof WebApplication) {
            this.fireEvent(this.config.getServletContext().getAttribute(WEB_APPLICATION_ATTRIBUTE_NAME), qualifier);
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
    }

    public String getServletInfo() {
        return "Seam Servlet module WebApplication event publisher";
    }
}

