/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.exception;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.exception.control.ExceptionToCatch;
import org.jboss.seam.servlet.literal.WebRequestLiteral;
import org.jboss.seam.servlet.support.ServletLogger;
import org.jboss.seam.solder.beanManager.BeanManagerAware;
import org.jboss.seam.solder.beanManager.BeanManagerUnavailableException;
import org.jboss.seam.solder.core.Requires;
import org.jboss.seam.solder.logging.Logger;

@Requires(value={"org.jboss.seam.exception.control.extension.CatchExtension"})
public class CatchExceptionFilter
extends BeanManagerAware
implements Filter {
    private transient ServletLogger log = (ServletLogger)Logger.getMessageLogger(ServletLogger.class, (String)"seam-servlet");
    private boolean enabled = false;

    public void init(FilterConfig config) throws ServletException {
        try {
            if (!this.getBeanManager().getBeans(CatchExceptionFilter.class, new Annotation[0]).isEmpty()) {
                this.enabled = true;
                this.log.catchIntegrationEnabled();
            }
        }
        catch (BeanManagerUnavailableException e) {
            this.log.catchIntegrationDisabledNoBeanManager();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block6: {
            if (!this.enabled) {
                chain.doFilter(request, response);
            } else {
                try {
                    chain.doFilter(request, response);
                }
                catch (Exception e) {
                    ExceptionToCatch catchEvent = request instanceof HttpServletRequest ? new ExceptionToCatch((Throwable)e, new Annotation[]{WebRequestLiteral.INSTANCE}) : new ExceptionToCatch((Throwable)e, new Annotation[]{WebRequestLiteral.INSTANCE});
                    this.getBeanManager().fireEvent((Object)catchEvent, new Annotation[0]);
                    if (catchEvent.isHandled()) break block6;
                    if (e instanceof ServletException) {
                        throw (ServletException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    public void destroy() {
    }
}

