/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.seam.validation.InjectingConstraintValidatorFactory;

public class ValidationExtension
implements Extension {
    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        this.addValidatorFactoryIfRequired(abd, bm);
        this.addValidatorIfRequired(abd, bm);
        this.addMethodValidator(abd, bm);
    }

    private void addValidatorFactoryIfRequired(AfterBeanDiscovery abd, final BeanManager beanManager) {
        if (!beanManager.getBeans(ValidatorFactory.class, new Annotation[0]).isEmpty()) {
            ValidatorFactory validatorFactory = this.getReference(beanManager, ValidatorFactory.class);
            ConstraintValidatorFactory constraintValidatorFactory = validatorFactory.getConstraintValidatorFactory();
            if (constraintValidatorFactory instanceof InjectingConstraintValidatorFactory) {
                this.inject(beanManager, InjectingConstraintValidatorFactory.class, (InjectingConstraintValidatorFactory)constraintValidatorFactory);
            }
            return;
        }
        abd.addBean((Bean)new Bean<ValidatorFactory>(){

            public Class<?> getBeanClass() {
                return ValidatorFactory.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public String getName() {
                return "validatorFactory";
            }

            public Set<Annotation> getQualifiers() {
                HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
                return qualifiers;
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                HashSet<Type> types = new HashSet<Type>();
                types.add((Type)((Object)ValidatorFactory.class));
                types.add((Type)((Object)Object.class));
                return types;
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public ValidatorFactory create(CreationalContext<ValidatorFactory> ctx) {
                ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
                ConstraintValidatorFactory constraintValidatorFactory = validatorFactory.getConstraintValidatorFactory();
                if (constraintValidatorFactory instanceof InjectingConstraintValidatorFactory) {
                    ValidationExtension.this.inject(beanManager, InjectingConstraintValidatorFactory.class, (InjectingConstraintValidatorFactory)constraintValidatorFactory);
                }
                return validatorFactory;
            }

            public void destroy(ValidatorFactory instance, CreationalContext<ValidatorFactory> ctx) {
            }
        });
    }

    private void addValidatorIfRequired(AfterBeanDiscovery abd, final BeanManager bm) {
        if (!bm.getBeans(Validator.class, new Annotation[0]).isEmpty()) {
            return;
        }
        abd.addBean((Bean)new Bean<Validator>(){

            public Class<?> getBeanClass() {
                return Validator.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public String getName() {
                return "validator";
            }

            public Set<Annotation> getQualifiers() {
                HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
                return qualifiers;
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                HashSet<Type> types = new HashSet<Type>();
                types.add((Type)((Object)MethodValidator.class));
                types.add((Type)((Object)Validator.class));
                types.add((Type)((Object)Object.class));
                return types;
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public Validator create(CreationalContext<Validator> ctx) {
                ValidatorFactory validatorFactory = (ValidatorFactory)ValidationExtension.this.getReference(bm, ValidatorFactory.class);
                return validatorFactory.getValidator();
            }

            public void destroy(Validator instance, CreationalContext<Validator> ctx) {
            }
        });
    }

    private void addMethodValidator(AfterBeanDiscovery abd, final BeanManager bm) {
        abd.addBean((Bean)new Bean<MethodValidator>(){

            public Class<?> getBeanClass() {
                return MethodValidator.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public String getName() {
                return "methodValidator";
            }

            public Set<Annotation> getQualifiers() {
                HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
                return qualifiers;
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                HashSet<Type> types = new HashSet<Type>();
                types.add((Type)((Object)MethodValidator.class));
                types.add((Type)((Object)Object.class));
                return types;
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public MethodValidator create(CreationalContext<MethodValidator> ctx) {
                return (MethodValidator)((ValidatorFactory)ValidationExtension.this.getReference(bm, ValidatorFactory.class)).getValidator().unwrap(MethodValidator.class);
            }

            public void destroy(MethodValidator instance, CreationalContext<MethodValidator> ctx) {
            }
        });
    }

    private <T> T getReference(BeanManager bm, Class<T> clazz) {
        Bean bean = (Bean)bm.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext context = bm.createCreationalContext((Contextual)bean);
        return (T)bm.getReference(bean, clazz, context);
    }

    private <T> void inject(BeanManager beanManager, Class<T> type, T constraintValidatorFactory) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(type);
        InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
        CreationalContext cvfCtx = beanManager.createCreationalContext(null);
        it.inject(constraintValidatorFactory, cvfCtx);
        it.postConstruct(constraintValidatorFactory);
    }
}

