/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.pullrequest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.assistant.Constants;
import org.jboss.set.assistant.Util;
import org.jboss.set.assistant.data.PullRequestData;
import org.jboss.set.assistant.evaluator.Evaluator;
import org.jboss.set.assistant.evaluator.EvaluatorContext;

public class PullRequestRelatedEvaluator
implements Evaluator {
    private static final Logger logger = Logger.getLogger(PullRequestRelatedEvaluator.class.getCanonicalName());

    @Override
    public String name() {
        return "Pull Request Related Evaluator";
    }

    @Override
    public void eval(EvaluatorContext context, Map<String, Object> data) {
        Set<PullRequest> relatedPatches = context.getRelated();
        Aphrodite aphrodite = context.getAphrodite();
        ArrayList<PullRequestData> links = new ArrayList<PullRequestData>();
        for (PullRequest pullRequest : relatedPatches) {
            URI uri = Util.convertURLtoURI(pullRequest.getRepository().getURL());
            if (uri == null) continue;
            List streams = aphrodite.getStreamsBy(uri, pullRequest.getCodebase());
            List<String> streamsStr = streams.stream().map(e -> e.getName()).collect(Collectors.toList());
            boolean isNoUpstreamRequired = false;
            isNoUpstreamRequired = this.isNoUpstreamRequired(pullRequest);
            Optional<CommitStatus> commitStatus = Optional.of(CommitStatus.UNKNOWN);
            try {
                commitStatus = Optional.of(aphrodite.getCommitStatusFromPullRequest(pullRequest));
            }
            catch (NotFoundException e2) {
                logger.log(Level.FINE, "Unable to find build result for pull request : " + pullRequest.getURL(), e2);
            }
            links.add(new PullRequestData(pullRequest.getId(), streamsStr, pullRequest.getURL(), pullRequest.getCodebase().getName(), pullRequest.getState().toString(), commitStatus.orElse(CommitStatus.UNKNOWN).toString(), isNoUpstreamRequired));
        }
        data.put("pullRequestsRelated", links);
    }

    private boolean isNoUpstreamRequired(PullRequest pullRequest) {
        Optional<String> pullRequestBoday = Optional.ofNullable(pullRequest.getBody());
        Matcher matcher = Constants.UPSTREAM_NOT_REQUIRED.matcher(pullRequestBoday.orElse("N/A"));
        return matcher.find();
    }
}

