/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.pullrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.set.aphrodite.domain.Flag;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.assistant.data.LabelData;
import org.jboss.set.assistant.evaluator.Evaluator;
import org.jboss.set.assistant.evaluator.EvaluatorContext;
import org.jboss.set.assistant.evaluator.Util;

public class LabelsEvaluator
implements Evaluator {
    private static Logger logger = Logger.getLogger("org.jboss.pull");

    @Override
    public String name() {
        return "Labels evaluator";
    }

    @Override
    public void eval(EvaluatorContext context, Map<String, Object> data) {
        Patch patch = context.getPatch();
        Set<Issue> issues = context.getIssues();
        if (issues.isEmpty()) {
            logger.log(Level.WARNING, "No issues found in patch, " + this.name() + " not applied to " + patch.getURL());
        }
        HashMap labels = new HashMap();
        HashMap okays = new HashMap();
        data.put("labels", labels);
        data.put("status", okays);
        for (Issue issue : issues) {
            boolean hasStreams;
            ArrayList<LabelData> tmp = new ArrayList<LabelData>();
            labels.put(issue.getTrackerId().get(), tmp);
            boolean hasAllFlags = true;
            for (Flag flag : Flag.values()) {
                FlagStatus status = issue.getStage().getStatus(flag);
                if (status.equals((Object)FlagStatus.ACCEPTED)) continue;
                hasAllFlags = false;
                break;
            }
            boolean bl = hasStreams = !Util.getStreams(issue).isEmpty();
            if (hasStreams) {
                okays.put(issue.getTrackerId().get(), hasAllFlags ? 1 : 3);
            } else {
                okays.put(issue.getTrackerId().get(), 2);
            }
            tmp.add(new LabelData(context.getBranch(), true));
            tmp.add(new LabelData("Has All Acks", hasAllFlags));
            for (Flag flag : Flag.values()) {
                String label = null;
                switch (flag) {
                    case DEV: {
                        label = "Needs devel_ack";
                        break;
                    }
                    case QE: {
                        label = "Needs qa_ack";
                        break;
                    }
                    case PM: {
                        label = "Needs pm_ack";
                    }
                }
                FlagStatus status = issue.getStage().getStatus(flag);
                tmp.add(new LabelData(label, !status.equals((Object)FlagStatus.ACCEPTED)));
            }
        }
    }
}

