/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant;

import java.net.URL;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.spi.IssueHome;
import org.jboss.set.aphrodite.simplecontainer.SimpleContainer;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class IssueHomeService
implements IssueHome {
    private static final Logger logger = Logger.getLogger(IssueHomeService.class.getCanonicalName());
    private static Aphrodite aphrodite;

    public Stream<Issue> findUpstreamReferences(Issue issue) {
        HashSet<Issue> upstreamIssues = new HashSet<Issue>();
        if (aphrodite != null) {
            for (URL url : issue.getDependsOn()) {
                try {
                    upstreamIssues.add(aphrodite.getIssue(url));
                }
                catch (NotFoundException e) {
                    logger.log(Level.WARNING, "Unable to find issue with url: " + url, e);
                }
            }
        }
        return upstreamIssues.stream();
    }

    static {
        try {
            aphrodite = (Aphrodite)SimpleContainer.instance().lookup(Aphrodite.class.getSimpleName(), Aphrodite.class);
        }
        catch (NameNotFoundException e) {
            logger.log(Level.SEVERE, "Can not get aphrodite service due to : ", e);
        }
    }
}

