/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.PatchType;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.spi.PatchHome;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssue;
import org.jboss.set.aphrodite.simplecontainer.SimpleContainer;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.assistant.Constants;
import org.jboss.set.assistant.Util;

public class PatchHomeService
implements PatchHome {
    private static final Logger logger = Logger.getLogger(PatchHomeService.class.getCanonicalName());
    private static Aphrodite aphrodite;

    public Stream<Patch> findPatchesByIssue(Issue issue) {
        if (issue.getTrackerType().equals(TrackerType.JIRA)) {
            List urls = ((JiraIssue)issue).getPullRequests();
            return this.mapURLtoPatchStream(urls);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        issue.getComments().stream().forEach(e -> this.extractPullRequests(urls, e.getBody()));
        return this.mapURLtoPatchStream(urls);
    }

    private Stream<Patch> mapURLtoPatchStream(List<URL> urls) {
        return urls.stream().map(e -> {
            PatchType patchType = this.getPatchType((URL)e);
            PatchState patchState = this.getPatchState((URL)e, patchType);
            return new Patch(e, this.getPatchType((URL)e), patchState);
        });
    }

    private PatchType getPatchType(URL url) {
        String urlStr = url.toString();
        if (urlStr.contains("/pull/")) {
            return PatchType.PULLREQUEST;
        }
        if (urlStr.contains("/commit/")) {
            return PatchType.COMMIT;
        }
        return PatchType.FILE;
    }

    private PatchState getPatchState(URL url, PatchType patchType) {
        if (patchType.equals((Object)PatchType.PULLREQUEST)) {
            try {
                PullRequest pullRequest = aphrodite.getPullRequest(url);
                return PatchState.valueOf((String)pullRequest.getState().toString());
            }
            catch (NotFoundException e) {
                logger.log(Level.WARNING, "Unable to find pull request with url: " + url, e);
            }
        } else if (patchType.equals((Object)PatchType.COMMIT)) {
            return PatchState.CLOSED;
        }
        return PatchState.UNDEFINED;
    }

    private void extractPullRequests(List<URL> pullRequests, String messageBody) {
        Matcher matcher = Constants.RELATED_PR_PATTERN.matcher(messageBody);
        while (matcher.find()) {
            if (matcher.groupCount() != 3) continue;
            String urlStr = "https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/pull/" + matcher.group(3);
            try {
                URL url = new URL(urlStr);
                pullRequests.add(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL:" + urlStr, e);
            }
        }
    }

    public static Collection<PullRequest> filterRelatedPatch(Collection<PullRequest> pullRequest, org.jboss.set.aphrodite.domain.Stream stream) {
        return pullRequest.stream().filter(e -> PatchHomeService.filterByStream(e, stream)).collect(Collectors.toSet());
    }

    public static boolean filterByStream(PullRequest pullRequest, org.jboss.set.aphrodite.domain.Stream stream) {
        Codebase codebase = pullRequest.getCodebase();
        Repository repository = pullRequest.getRepository();
        URI uri = Util.convertURLtoURI(repository.getURL());
        if (uri != null) {
            return stream.getAllComponents().stream().anyMatch(e -> e.getCodebase().equals((Object)codebase) && e.getRepositoryURL().equals(uri));
        }
        return false;
    }

    public static boolean isNoUpstreamRequired(PullRequest pullRequest) {
        Optional<String> pullRequestBoday = Optional.ofNullable(pullRequest.getBody());
        Matcher matcher = Constants.UPSTREAM_NOT_REQUIRED.matcher(pullRequestBoday.orElse("N/A"));
        return matcher.find();
    }

    public static Optional<CommitStatus> retrieveCommitStatus(PullRequest pullRequest) {
        Optional<CommitStatus> commitStatus = Optional.of(CommitStatus.UNKNOWN);
        if (aphrodite != null) {
            try {
                commitStatus = Optional.of(aphrodite.getCommitStatusFromPullRequest(pullRequest));
            }
            catch (NotFoundException e) {
                logger.log(Level.FINE, "Unable to find build result for pull request : " + pullRequest.getURL(), e);
            }
        }
        return commitStatus;
    }

    static {
        try {
            aphrodite = (Aphrodite)SimpleContainer.instance().lookup(Aphrodite.class.getSimpleName(), Aphrodite.class);
        }
        catch (NameNotFoundException e1) {
            logger.log(Level.SEVERE, "Can not get aphrodite service due to : ", e1);
        }
    }
}

