/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.data.payload;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.jboss.jbossset.bugclerk.Severity;
import org.jboss.jbossset.bugclerk.Violation;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.IssueType;
import org.jboss.set.assistant.Util;

public class PayloadIssue {
    private URL link;
    private String label;
    private String summary;
    private IssueStatus status;
    private IssueType type;
    private Map<String, String> flags;
    private Collection<Violation> violations;
    private Severity maxSeverity;

    public PayloadIssue(URL link, String label, String summary, IssueStatus status, IssueType type, Map<String, String> flags, Collection<Violation> violations) {
        this.link = link;
        this.label = label;
        this.summary = summary;
        this.status = status;
        this.type = type;
        this.flags = flags;
        this.violations = violations;
        this.maxSeverity = violations.stream().map(violation -> violation.getLevel()).reduce((severity1, severity2) -> Util.maxSeverity(severity1, severity2)).orElse(null);
    }

    public URL getLink() {
        return this.link;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSummary() {
        return this.summary;
    }

    public IssueStatus getStatus() {
        return this.status;
    }

    public IssueType getType() {
        return this.type;
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }

    public Collection<Violation> getViolations() {
        return this.violations;
    }

    public Severity getMaxSeverity() {
        return this.maxSeverity;
    }
}

