/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.Issue;

public final class Util {
    private static final Pattern patternStreamFlagBuzilla = Pattern.compile("jboss-eap-[0-9]\\.[0-9]\\.[0-9z]");
    private static final Pattern patternStreamFlagJira = Pattern.compile("[0-9]\\.[a-zA-Z]*(\\.[0-9z])?(\\.[a-zA-Z]*)?");

    private Util() {
    }

    public static List<String> getStreams(Issue issue) {
        EnumSet<FlagStatus> set = EnumSet.of(FlagStatus.ACCEPTED, FlagStatus.SET);
        ArrayList<String> streams = new ArrayList<String>();
        Map statuses = issue.getStreamStatus();
        for (Map.Entry status : statuses.entrySet()) {
            String stream = Util.extract((String)status.getKey());
            if (stream == null || !set.contains(status.getValue())) continue;
            streams.add(stream);
        }
        return streams;
    }

    public static String extract(String value) {
        Matcher matcherBugzilla = patternStreamFlagBuzilla.matcher(value);
        Matcher matcherJira = patternStreamFlagJira.matcher(value);
        if (matcherBugzilla.find()) {
            String bugzilla = matcherBugzilla.group();
            return bugzilla;
        }
        if (matcherJira.find()) {
            return matcherJira.group();
        }
        return null;
    }
}

