/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.payload;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.naming.NameNotFoundException;
import org.jboss.jbossset.bugclerk.Violation;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.simplecontainer.SimpleContainer;
import org.jboss.set.assistant.ViolationHome;
import org.jboss.set.assistant.data.payload.PayloadIssue;
import org.jboss.set.assistant.evaluator.PayloadEvaluator;
import org.jboss.set.assistant.evaluator.PayloadEvaluatorContext;

public class PayloadIssueEvaluator
implements PayloadEvaluator {
    public static final String KEY = "payloadDependency";
    private static final Logger logger = Logger.getLogger(PayloadIssueEvaluator.class.getCanonicalName());

    @Override
    public String name() {
        return "PayloadIssue Evaluator";
    }

    @Override
    public void eval(PayloadEvaluatorContext context, Map<String, Object> data) {
        Issue dependencyIssue = context.getIssue();
        ArrayList<Violation> violations = new ArrayList();
        try {
            violations = ((ViolationHome)SimpleContainer.instance().lookup(ViolationHome.class.getSimpleName(), ViolationHome.class)).findViolations(dependencyIssue).collect(Collectors.toList());
        }
        catch (NameNotFoundException e2) {
            logger.log(Level.SEVERE, "Can not get ViolationHome service due to ", e2);
        }
        data.put(KEY, new PayloadIssue(dependencyIssue.getURL(), dependencyIssue.getTrackerId().orElse("N/A"), dependencyIssue.getSummary().orElse("N/A"), dependencyIssue.getStatus(), dependencyIssue.getType(), dependencyIssue.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))), violations));
    }
}

