/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.pullrequest;

import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.assistant.Constants;
import org.jboss.set.assistant.data.payload.AssociatedPullRequest;
import org.jboss.set.assistant.evaluator.Evaluator;
import org.jboss.set.assistant.evaluator.EvaluatorContext;

public class PullRequestEvaluator
implements Evaluator {
    private static final Logger logger = Logger.getLogger(PullRequestEvaluator.class.getCanonicalName());

    @Override
    public String name() {
        return "Pull Request Evaluator";
    }

    @Override
    public void eval(EvaluatorContext context, Map<String, Object> data) {
        PullRequest pullRequest = context.getPullRequest();
        boolean isNoUpstreamRequired = false;
        isNoUpstreamRequired = this.isNoUpstreamRequired(pullRequest);
        Aphrodite aphrodite = context.getAphrodite();
        Optional<CommitStatus> commitStatus = Optional.of(CommitStatus.UNKNOWN);
        try {
            commitStatus = Optional.of(aphrodite.getCommitStatusFromPullRequest(pullRequest));
        }
        catch (NotFoundException e) {
            logger.log(Level.FINE, "Unable to find build result for pull request : " + pullRequest.getURL(), e);
        }
        data.put("pullRequest", new AssociatedPullRequest(pullRequest.getId(), pullRequest.getURL(), pullRequest.getCodebase().getName(), pullRequest.getState().toString(), commitStatus.orElse(CommitStatus.UNKNOWN).toString(), isNoUpstreamRequired));
    }

    private boolean isNoUpstreamRequired(PullRequest pullRequest) {
        Optional<String> pullRequestBoday = Optional.ofNullable(pullRequest.getBody());
        Matcher matcher = Constants.UPSTREAM_NOT_REQUIRED.matcher(pullRequestBoday.orElse("N/A"));
        return matcher.find();
    }
}

