/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.payload;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.IssueType;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssue;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.assistant.Constants;
import org.jboss.set.assistant.data.payload.DependsOnIssue;
import org.jboss.set.assistant.evaluator.PayloadEvaluator;
import org.jboss.set.assistant.evaluator.PayloadEvaluatorContext;

public class DependsOnEvaluator
implements PayloadEvaluator {
    private static final Logger logger = Logger.getLogger(DependsOnEvaluator.class.getCanonicalName());
    public static final String KEY = "dependsOn";

    @Override
    public String name() {
        return "Depends On Evaluator";
    }

    @Override
    public void eval(PayloadEvaluatorContext context, Map<String, Object> data) {
        Aphrodite aphrodite = context.getAphrodite();
        Issue dependencyIssue = context.getIssue();
        org.jboss.set.aphrodite.domain.Stream stream = context.getStream();
        Stream upstreamReferences = Stream.empty();
        try {
            if (dependencyIssue instanceof JiraIssue) {
                upstreamReferences = dependencyIssue.getUpstreamReferences();
            } else {
                HashSet<Issue> upstreamIssues = new HashSet<Issue>();
                for (URL url : dependencyIssue.getDependsOn()) {
                    try {
                        upstreamIssues.add(aphrodite.getIssue(url));
                    }
                    catch (NotFoundException e) {
                        logger.log(Level.WARNING, "Unable to find issue with url: " + url, e);
                    }
                }
                if (!upstreamIssues.isEmpty()) {
                    upstreamReferences = upstreamIssues.stream();
                }
            }
        }
        catch (NameNotFoundException e) {
            logger.log(Level.SEVERE, "Unable to load service due to " + e.getMessage(), e);
        }
        ArrayList dependsOnIssues = new ArrayList();
        if (context.getTrackerType().equals((Object)TrackerType.BUGZILLA)) {
            Issue payloadTracker = context.getPayloadTracker();
            upstreamReferences.forEach(issue -> {
                boolean inPayload = issue.getBlocks().stream().anyMatch(e -> this.extractId((URL)e).equalsIgnoreCase((String)payloadTracker.getTrackerId().get())) || this.checkIsReleased((Issue)issue) || this.checkIssueType((Issue)issue) || !this.matchStream((Issue)issue, stream);
                dependsOnIssues.add(new DependsOnIssue(issue.getURL(), issue.getTrackerId().orElse("N/A"), issue.getSummary().orElse("N/A"), issue.getStatus(), issue.getType(), issue.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))), Collections.emptyList(), inPayload, this.getFixVersions((Issue)issue), this.getPayload((Issue)issue), issue.getStreamStatus()));
            });
        } else {
            upstreamReferences.forEach(issue -> {
                String fixVersion = context.getFixVersion();
                boolean inPayload = this.checkFixVersion((Issue)issue, fixVersion) || this.checkIsReleased((Issue)issue) || this.checkIssueType((Issue)issue) || !this.matchStream((Issue)issue, stream);
                dependsOnIssues.add(new DependsOnIssue(issue.getURL(), issue.getTrackerId().orElse("N/A"), issue.getSummary().orElse("N/A"), issue.getStatus(), issue.getType(), issue.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))), Collections.emptyList(), inPayload, this.getFixVersions((Issue)issue), this.getPayload((Issue)issue), issue.getStreamStatus()));
            });
        }
        data.put(KEY, dependsOnIssues);
    }

    private boolean checkIsReleased(Issue issue) {
        IssueStatus issueStatus = issue.getStatus();
        return issueStatus.equals((Object)IssueStatus.VERIFIED) || issueStatus.equals((Object)IssueStatus.CLOSED) || issueStatus.equals((Object)IssueStatus.RELEASE_PENDING);
    }

    private boolean checkIssueType(Issue issue) {
        return issue.getType().equals((Object)IssueType.ONE_OFF);
    }

    private boolean matchStream(Issue issue, org.jboss.set.aphrodite.domain.Stream stream) {
        return issue.getStreamStatus().keySet().stream().anyMatch(e -> e.equals(stream.getName()));
    }

    private boolean checkFixVersion(Issue issue, String fixVersion) {
        List releases = issue.getReleases();
        return releases.stream().anyMatch(e -> {
            if (e.getVersion().isPresent()) {
                return ((String)e.getVersion().get()).equalsIgnoreCase(fixVersion);
            }
            return false;
        });
    }

    private String extractId(URL url) {
        Optional<String> str = Optional.empty();
        try {
            str = url.toString().toLowerCase().contains("bugzilla") ? Optional.ofNullable(Utils.getParamaterFromUrl((Pattern)Constants.BZ_ID_PARAM_PATTERN, (URL)url)) : Optional.ofNullable(this.getIssueKey(url));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return str.orElse("default");
    }

    private String getIssueKey(URL url) throws NotFoundException {
        String path = url.getPath();
        boolean api = path.contains("/rest/api/2/issue/");
        boolean browse = path.contains("/browse/");
        if (!api && !browse) {
            throw new NotFoundException("The URL path must be of the form '/rest/api/2/issue/' OR '/browse/'");
        }
        return api ? path.substring("/rest/api/2/issue/".length()) : path.substring("/browse/".length());
    }

    private List<String> getFixVersions(Issue issue) {
        return issue.getReleases().stream().filter(e -> e.getVersion().isPresent()).map(e -> (String)e.getVersion().get()).collect(Collectors.toList());
    }

    private String getPayload(Issue issue) {
        List<String> fixVersions = this.getFixVersions(issue);
        Optional<String> payload = fixVersions.stream().filter(e -> e.matches(Constants.EAP64XPAYLOADPATTERN.toString()) || e.matches(Constants.EAP70XPAYLOADPATTERN.toString())).findFirst();
        return payload.orElse("N/A");
    }
}

