/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.pullrequest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.assistant.Util;
import org.jboss.set.assistant.data.IssueData;
import org.jboss.set.assistant.evaluator.Evaluator;
import org.jboss.set.assistant.evaluator.EvaluatorContext;

public class IssuesRelatedEvaluator
implements Evaluator {
    @Override
    public String name() {
        return "Issues Related evaluator";
    }

    @Override
    public void eval(EvaluatorContext context, Map<String, Object> data) {
        Set<Issue> issues = context.getIssues();
        HashMap issueStream = new HashMap();
        for (Issue issue : issues) {
            List<String> streams = Util.getStreams(issue);
            issueStream.put(issue.getTrackerId().get(), streams);
        }
        Stream currentStream = context.getStream();
        Aphrodite aphrodite = context.getAphrodite();
        PullRequest pullRequest = context.getPullRequest();
        URI uri = Util.convertURLtoURI(pullRequest.getRepository().getURL());
        if (uri != null) {
            List streams = aphrodite.getStreamsBy(uri, pullRequest.getCodebase()).stream().map(e -> e.getName()).collect(Collectors.toList());
            if (currentStream.getName().contains("eap-6")) {
                data.put("issuesRelated", issues.stream().filter(e -> {
                    ArrayList intersect = new ArrayList(streams);
                    intersect.retainAll((Collection)issueStream.get(e.getTrackerId().get()));
                    return !intersect.isEmpty();
                }).map(e -> new IssueData(e.getURL(), (String)e.getTrackerId().get(), e.getSummary().orElse("N/A"), (List)issueStream.get(e.getTrackerId().get()), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))), e.getStreamStatus())).collect(Collectors.toList()));
                data.put("issuesOtherStreams", issues.stream().filter(e -> {
                    ArrayList intersect = new ArrayList(streams);
                    intersect.retainAll((Collection)issueStream.get(e.getTrackerId().get()));
                    return intersect.isEmpty();
                }).map(e -> new IssueData(e.getURL(), (String)e.getTrackerId().get(), e.getSummary().orElse("N/A"), (List)issueStream.get(e.getTrackerId().get()), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))), e.getStreamStatus())).collect(Collectors.toList()));
            } else if (currentStream.getName().contains("eap-7")) {
                data.put("issuesRelated", issues.stream().filter(e -> e.getStreamStatus().keySet().stream().filter(e1 -> this.checkStream(currentStream, (String)e1)).findAny().isPresent()).map(e -> new IssueData(e.getURL(), (String)e.getTrackerId().get(), e.getSummary().orElse("N/A"), (List)issueStream.get(e.getTrackerId().get()), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))), e.getStreamStatus())).collect(Collectors.toList()));
                data.put("issuesOtherStreams", issues.stream().filter(e -> e.getStreamStatus().keySet().stream().filter(e1 -> !this.checkStream(currentStream, (String)e1)).findAny().isPresent()).map(e -> new IssueData(e.getURL(), (String)e.getTrackerId().get(), e.getSummary().orElse("N/A"), (List)issueStream.get(e.getTrackerId().get()), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))), e.getStreamStatus())).collect(Collectors.toList()));
            } else {
                data.put("issuesRelated", issues.stream().map(e -> new IssueData(e.getURL(), (String)e.getTrackerId().get(), e.getSummary().orElse("N/A"), (List)issueStream.get(e.getTrackerId().get()), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))), e.getStreamStatus())).collect(Collectors.toList()));
                data.put("issuesOtherStreams", Collections.emptyList());
            }
        }
    }

    private boolean checkStream(Stream currentStream, String targetRelease) {
        String currentStreamName = currentStream.getName();
        if (currentStreamName.equals("jboss-eap-7.0.z")) {
            return targetRelease.equals("7.0.z.GA") || targetRelease.equals("7.backlog.GA");
        }
        if (currentStreamName.equals("jboss-eap-7.z.0")) {
            return targetRelease.equals("7.1.0.GA");
        }
        return false;
    }
}

