/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.MyPermissionsRestClient;
import com.atlassian.jira.rest.client.api.domain.Permissions;
import com.atlassian.jira.rest.client.api.domain.input.MyPermissionsInput;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.PermissionsJsonParser;
import com.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class AsynchronousMyPermissionsRestClient
extends AbstractAsynchronousRestClient
implements MyPermissionsRestClient {
    private static final String URI_PREFIX = "mypermissions";
    private final URI baseUri;
    private final PermissionsJsonParser permissionsJsonParser = new PermissionsJsonParser();

    protected AsynchronousMyPermissionsRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<Permissions> getMyPermissions(MyPermissionsInput permissionInput) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path(URI_PREFIX);
        this.addContextParams(uriBuilder, permissionInput);
        return this.getAndParse(uriBuilder.build(new Object[0]), this.permissionsJsonParser);
    }

    private UriBuilder addContextParams(UriBuilder uriBuilder, MyPermissionsInput permissionInput) {
        if (permissionInput != null) {
            if (permissionInput.getProjectKey() != null) {
                uriBuilder.queryParam("projectKey", permissionInput.getProjectKey());
            }
            if (permissionInput.getProjectId() != null) {
                uriBuilder.queryParam("projectId", permissionInput.getProjectId());
            }
            if (permissionInput.getIssueKey() != null) {
                uriBuilder.queryParam("issueKey", permissionInput.getIssueKey());
            }
            if (permissionInput.getIssueId() != null) {
                uriBuilder.queryParam("issueId", permissionInput.getIssueId());
            }
        }
        return uriBuilder;
    }
}

