/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.page;

import com.atlassian.sal.api.page.PageCapability;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class PageCapabilities {
    public static final String SEPARATOR = ",";

    public static EnumSet<PageCapability> empty() {
        return EnumSet.noneOf(PageCapability.class);
    }

    public static EnumSet<PageCapability> valueOf(@Nullable String values) {
        if (values == null || values.length() == 0) {
            return PageCapabilities.empty();
        }
        Collection<PageCapability> capabilities = Collections2.filter(Lists.transform(Arrays.asList(values.split(SEPARATOR)), new Function<String, PageCapability>(){

            @Override
            public PageCapability apply(String value) {
                try {
                    return PageCapability.valueOf(value);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }), Predicates.notNull());
        if (capabilities.isEmpty()) {
            return PageCapabilities.empty();
        }
        return EnumSet.copyOf(capabilities);
    }

    public static String toString(@Nonnull EnumSet<PageCapability> pageCaps) {
        return Joiner.on(SEPARATOR).join(pageCaps.iterator());
    }
}

